//=============================================================================
// Media Scripts
//=============================================================================
$(document).ready(function() {
    // Open media library modal
    $('#select-media-btn').on('click', function() {
        $('#media-library-modal').show();
        loadMediaLibrary(); // Load media library items via AJAX
    });

    // Close media library modal
    $('#close-media-library').on('click', function() {
        $('#media-library-modal').hide();
    });

    // Tabs for Upload and Library
    $('#media-tabs .nav-link').on('click', function(e) {
        e.preventDefault();
        $('#media-tabs .nav-link').removeClass('active');
        $(this).addClass('active');

        let target = $(this).attr('href');
        $('.tab-pane').removeClass('active');
        $(target).addClass('active');
    });

    // Load media library items via AJAX
    function loadMediaLibrary() {
        $.ajax({
            url: '{{ route("admin.media.library.ajax") }}',
            type: 'GET',
            success: function(response) {
                let mediaHtml = '';
                
                if (response.data.length > 0) {
                    // Generate media items
                    response.data.forEach(media => {
                        mediaHtml += `<div class="media-item" data-id="${media.id}">
                                        <img src="${media.url}" style="max-width: 100px;">
                                        <button class="select-media-btn">Select</button>
                                    </div>`;
                    });
                } else {
                    // Show message if no media files are available inside the media library tab
                    mediaHtml = '<div id="no-media-message">No media files available</div>';
                }

                $('#media-items').html(mediaHtml);  // Place message in media-items container (under media library tab)

                // Handle media selection
                $('.select-media-btn').on('click', function() {
                    let mediaId = $(this).closest('.media-item').data('id');
                    let mediaUrl = $(this).siblings('img').attr('src');
                    $('#featured_image').val(mediaId);  // Set the selected media ID
                    $('#featured-image-preview').html(`<img src="${mediaUrl}" style="max-width: 200px;">`);
                    $('#media-library-modal').hide();  // Close the modal
                });
            }
        });
    }

    // File upload functionality
    $('#media-upload-input').on('change', function() {
        let files = $(this)[0].files;
        let formData = new FormData();
        for (let i = 0; i < files.length; i++) {
            formData.append('file[]', files[i]);
        }

        $.ajax({
            url: '{{ route("admin.media.upload") }}',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // CSRF token
            },
            success: function(response) {
                if (response.success) {
                    let mediaHtml = '';
                    response.media.forEach(media => {
                        mediaHtml += `<div class="media-item" data-id="${media.file_name}">
                                        <img src="${media.file_path}" style="max-width: 100px;">
                                        <button class="select-media-btn">Select</button>
                                    </div>`;
                    });
                    $('#upload-preview').html(mediaHtml);

                    // After upload, attach click events to select buttons
                    $('.select-media-btn').on('click', function() {
                        let mediaId = $(this).closest('.media-item').data('id');
                        let mediaUrl = $(this).siblings('img').attr('src');
                        $('#featured_image').val(mediaId);  // Set the selected media ID
                        $('#featured-image-preview').html(`<img src="${mediaUrl}" style="max-width: 200px;">`);
                        $('#media-library-modal').hide();  // Close the modal
                    });
                }
            }
        });
    });
});