/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import {
    type Localization,
    type ValidateFunctionInterface,
    type ValidateOptions,
    type ValidateResult,
} from '@form-validation/core';

export interface StepOptions extends ValidateOptions {
    baseValue: number;
    step: number;
}
export interface StepLocalization extends Localization {
    step: {
        default: string;
    };
}

export function step(): ValidateFunctionInterface<StepOptions, ValidateResult>;
