/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import { Plugin } from '@form-validation/core';
import { type IconPlacedEvent } from '@form-validation/plugin-icon';
import { type MessagePlacedEvent } from '@form-validation/plugin-message';

export type RowSelector = (field: string, element: HTMLElement) => string;

export interface FrameworkOptions {
    defaultMessageContainer?: boolean;
    formClass: string;
    messageClass?: string;
    rowInvalidClass: string;
    // A list of CSS classes (separated by a space) that will be added to the row
    rowClasses?: string;
    rowPattern: RegExp;
    rowSelector: string | RowSelector;
    rowValidatingClass?: string;
    rowValidClass: string;
    // A CSS class added to valid element
    eleValidClass?: string;
    // A CSS class added to invalid element
    eleInvalidClass?: string;
}

export class Framework extends Plugin<FrameworkOptions> {
    static MESSAGE_PLUGIN: string;
    constructor(opts?: FrameworkOptions);

    protected onIconPlaced(e: IconPlacedEvent): void;
    protected onMessagePlaced(e: MessagePlacedEvent): void;
}
