<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if admin user already exists
        if (!User::where('email', 'admin@kholoudlab.com')->exists()) {
            DB::table('users')->insert([
                'name' => 'Kholoud Lab Admin',
                'email' => 'admin@kholoudlab.com',
                'phone' => '01003104158',
                'password' => Hash::make('admin'),
                'username' =>'kholoudlab',
            ]);
        }
    }
}
