<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if the table already exists
        if (!Schema::hasTable('student_notes')) {
            Schema::create('student_notes', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('student_id');  // Foreign key to students table
                $table->unsignedBigInteger('user_id');     // Foreign key to users table (who created the note)
                $table->text('content');                  // Note content
                $table->timestamps();    
            
                // Foreign key constraints
                $table->foreign('student_id')->references('id')->on('students')->onDelete('cascade');
                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('student_notes', function (Blueprint $table) {
            $table->dropForeign(['student_id']);
            $table->dropForeign(['user_id']);
        });

        Schema::dropIfExists('student_notes');
    }
};
