<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * This method creates a pivot table for the many-to-many sibling relationship
     * between students.
     *
     * @return void
     */
    public function up()
    {
        // Check if the table already exists
        if (!Schema::hasTable('student_siblings')) {
            Schema::create('student_siblings', function (Blueprint $table) {
                $table->id(); // Primary key
                
                // Foreign keys for the two students in the sibling relationship
                $table->unsignedBigInteger('student_id');
                $table->unsignedBigInteger('sibling_id');
                
                // Timestamps
                $table->timestamps();

                // Foreign key constraints
                $table->foreign('student_id')->references('id')->on('students')->onDelete('cascade');
                $table->foreign('sibling_id')->references('id')->on('students')->onDelete('cascade');
                
                // Ensure each pair of siblings is unique and prevent duplicate entries
                $table->unique(['student_id', 'sibling_id']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * This method drops the foreign key constraints and then drops the student_siblings pivot table,
     * effectively undoing the up() method.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('student_siblings', function (Blueprint $table) {
            // Drop foreign key constraints before dropping the table
            $table->dropForeign(['student_id']);
            $table->dropForeign(['sibling_id']);
        });

        // Now safely drop the student_siblings table
        Schema::dropIfExists('student_siblings');
    }
};
