<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
/**
     * Run the migrations.
     *
     * This method creates the student_contacts table which stores multiple contact numbers
     * for each student.
     *
     * @return void
     */
    public function up()
    {
        // Check if the table already exists
        if (!Schema::hasTable('student_contacts')) {
            Schema::create('student_contacts', function (Blueprint $table) {
                $table->id(); // Primary key: Auto-incrementing ID for the contact.
                
                // Foreign key to associate the contact with a student
                $table->unsignedBigInteger('student_id');

                $table->string('contact_number'); // The actual contact number
                $table->enum('type', ['home', 'mobile']); // Type of the number (home or mobile)
                $table->enum('owned_by', ['father', 'mother', 'other']); // Who the number belongs to
                $table->text('notes')->nullable(); // Additional notes for the contact (optional)

                $table->timestamps(); // Timestamps for created_at and updated_at

                // Foreign key constraint to link the contact to a student
                $table->foreign('student_id')->references('id')->on('students')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * This method drops the student_contacts table if it exists, effectively undoing the up() method.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('student_contacts', function (Blueprint $table) {
            $table->dropForeign(['student_id']); // Drop the foreign key constraint before dropping the table
        });

        Schema::dropIfExists('student_contacts'); // Drop the contacts table
    }
};
