<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if the table already exists
        if (!Schema::hasTable('neighborhoods')) {
            Schema::create('neighborhoods', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->unsignedBigInteger('district_id');
                $table->timestamps();
        
                // Foreign key constraint to districts table
                $table->foreign('district_id')->references('id')->on('districts')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // First, drop the foreign key constraint before dropping the table
        Schema::table('neighborhoods', function (Blueprint $table) {
            $table->dropForeign(['district_id']);
        });

        // Then drop the neighborhoods table
        Schema::dropIfExists('neighborhoods');
    }
};
