<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if the table already exists
        if (!Schema::hasTable('announcement_user')) {
            Schema::create('announcement_user', function (Blueprint $table) {
                $table->id();
                $table->foreignId('announcement_id')->constrained()->onDelete('cascade');
                $table->foreignId('user_id')->constrained()->onDelete('cascade');
                $table->boolean('is_seen')->default(false); // Track if the user has seen the announcement
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // First, we need to drop the foreign key constraints
        Schema::table('announcement_user', function (Blueprint $table) {
            $table->dropForeign(['announcement_id']); // Drop the foreign key for announcements
            $table->dropForeign(['user_id']);         // Drop the foreign key for users
        });

        // Then, we drop the entire table
        Schema::dropIfExists('announcement_user');
    }
};
