<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if the table already exists
        if (!Schema::hasTable('media')) {
            Schema::create('media', function (Blueprint $table) {
                $table->id();
                $table->string('file_name');               // Original file name
                $table->string('file_path');               // Path where the file is stored
                $table->string('file_type');               // File type (image, video, etc.)
                $table->string('mime_type');               // MIME type of the file
                $table->unsignedBigInteger('uploaded_by'); // User who uploaded the file
                $table->timestamps();

                // Foreign key to link with users table
                $table->foreign('uploaded_by')->references('id')->on('users')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('media');
    }
};
