<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if the table already exists
        if (!Schema::hasTable('users')) {
            Schema::create('users', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->string('email')->unique();
                $table->timestamp('email_verified_at')->nullable();
                $table->string('password');
                $table->uuid('username')->unique()->nullable();
                $table->string('gender')->default('male');
                $table->string('phone')->nullable();
                $table->string("photo")->nullable();
                $table->string("whatsapp")->nullable();
                $table->date("birthdate")->nullable();
                $table->boolean('active')->default(1);
                $table->boolean('online')->default(0);
                $table->text('about')->nullable();
                $table->string('position')->nullable(); // Position field
                $table->date('hired_date')->nullable(); // Hired date
                $table->string('department')->nullable(); // Department field
                $table->rememberToken();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};