<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if the table already exists
        if (!Schema::hasTable('schools')) {
            Schema::create('schools', function (Blueprint $table) {
                $table->id(); // This sets the 'id' column as an unsignedBigInteger
                $table->string('name');                         // Required field
                $table->string('registration_code')->unique();  // Unique code for the school
                $table->string('logo')->nullable();
                $table->string('address')->nullable();          // Address information
                $table->string('city');
                $table->string('state');
                $table->string('country');
                $table->string('zipcode')->nullable();
                $table->string('email')->unique();              // Contact email
                $table->string('phone')->nullable();            // Contact phone
                $table->string('website')->nullable();          // Website URL
                $table->string('principal_name')->nullable();   // Principal's name
                $table->integer('founded_year')->nullable();    // Year founded
                $table->integer('student_capacity')->nullable();// Student capacity
                $table->enum('type', ['public', 'private', 'charter'])->nullable(); // School type
                $table->enum('status', ['active', 'inactive', 'pending'])->default('active'); // School status
                $table->softDeletes();                          // Soft delete
                $table->timestamps();                           // Created and updated timestamps
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('schools');
    }
};
