<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'username',
        'phone',
        'photo',
        'gender',
        'whatsapp',
        'birthdate',
        'active',
        'online',
        'about',
        'position',
        'hired_date',
        'department',
        'school_id',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    public function isSuperAdmin()
    {
        return $this->hasRole('Super Admin');  // Assuming you're using a roles system (e.g., Spatie Permissions)
    }

    public function medias()
    {
        return $this->hasMany(Media::class);
    }

    // Define the many-to-one relationship
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function announcements()
    {
        return $this->belongsToMany(Announcement::class)->withPivot('is_seen')->withTimestamps();
    }
}
