<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Student extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'full_name', 'father_name', 'father_job', 'mother_name', 'mother_job', 'date_of_birth',
        'religion', 'gender', 'home_phone_number', 'is_transferred', 'former_school_name',
        'address', 'nationality', 'place_of_birth', 'national_id', 'year_of_entry',
        'photo_path', 'birth_certificate_path', 'is_active', 'grade_id', 'school_id', 
        'neighborhood_id', 'created_by'
    ];

    // Relationships

    /**
     * Get the school the student belongs to.
     */
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    /**
     * Get the grade the student belongs to.
     */
    public function grade()
    {
        return $this->belongsTo(Grade::class);
    }

    /**
     * Get the neighborhood the student lives in.
     */
    public function neighborhood()
    {
        return $this->belongsTo(Neighborhood::class);
    }

    /**
     * Get all contacts associated with the student.
     */
    public function contacts()
    {
        return $this->hasMany(Contact::class);
    }

    /**
     * Get the user (employee) who created the student record.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Get the siblings of the student.
     */
    public function siblings()
    {
        return $this->belongsToMany(Student::class, 'student_siblings', 'student_id', 'sibling_id')->withTimestamps();
    }

    /**
     * Get the notes of the student.
     */
    public function notes()
    {
        return $this->hasMany(Note::class);
    }
}
