<?php

// app/Models/Setting.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    protected $fillable = ['key', 'value', 'type', 'group', 'description', 'options'];

    protected $casts = [
        'options' => 'array', // This will automatically decode JSON strings to arrays
    ];
    
    protected static function boot()
    {
        parent::boot();
    
        static::saved(function ($setting) {
            \Cache::forget('setting_' . $setting->key);
        });
    }

    // Function to get the setting value based on type
    public function getValueAttribute($value)
    {
        switch ($this->type) {
            case 'json': // Handle array values or JSON encoded data
                return json_decode($value, true);
            case 'file': // Handle file uploads
                return asset('storage/' . $value);
            default:
                return $value;
        }
    }

    // Set values dynamically (for multiple types)
    public function setValueAttribute($value)
    {
        /*
        switch ($this->type) {
            case 'boolean':
                $this->attributes['value'] = (bool) $value;
                break;
            case 'integer':
                $this->attributes['value'] = (int) $value;
                break;
            case 'json':
                $this->attributes['value'] = json_encode($value);
                break;
            default:
                $this->attributes['value'] = $value;
        }
        */

        if (is_array($value)) {
            $this->attributes['value'] = json_encode($value);
        } else {
            $this->attributes['value'] = $value;
        }
    }
}