<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class School extends Model
{
    use SoftDeletes;  // Enables soft delete functionality

    protected $fillable = [
        'name', 'registration_code', 'address', 'city', 'state', 'country', 'zipcode',
        'email', 'phone', 'website', 'principal_name', 'founded_year', 'student_capacity',
        'type', 'status', 'logo',
    ];

    protected $dates = ['deleted_at'];  // For handling soft delete timestamps

    // Define the one-to-many relationship
    public function users()
    {
        return $this->hasMany(User::class);
    }

    // Define the one-to-many relationship
    public function grades()
    {
        return $this->hasMany(Grade::class);
    }

    // Define the one-to-many relationship
    public function students()
    {
        return $this->hasMany(Student::class);
    }
}