<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Page extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'title', 'slug', 'content', 'status', 'meta_title', 'meta_description', 'featured_image', 'gallery_images', 'video', 'parent_id', 'publish_at', 'created_by', 'updated_by'
    ];

    protected $casts = [
        'gallery_images' => 'array', // Handle gallery images as an array
        'publish_at' => 'datetime',
    ];

    // Relationship for parent/child pages
    public function parent()
    {
        return $this->belongsTo(Page::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(Page::class, 'parent_id');
    }

    // Relationship for user who created
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    // Relationship for user who updated
    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
