<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Note extends Model
{
    use HasFactory;

    // Explicitly specify the table name if it doesn't follow the Laravel convention
    protected $table = 'student_notes';

    // Define any fillable fields for mass assignment
    protected $fillable = ['content', 'student_id', 'user_id'];

    // Define the relationship with the Student model
    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    // Define the relationship with the User model (who created the note)
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}