<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Neighborhood extends Model
{
    protected $fillable = ['name', 'district_id'];

    // Relationship with district
    public function district()
    {
        return $this->belongsTo(District::class);
    }

    // Relationship with students
    public function students()
    {
        return $this->hasMany(Student::class);
    }
}
