<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Announcement extends Model
{
    protected $fillable = ['title', 'message', 'type', 'end_date', 'is_permanent'];

    public function users()
    {
        return $this->belongsToMany(User::class)->withPivot('is_seen')->withTimestamps();
    }
}
