<?php

namespace App\Http\Middleware\App;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Spatie\Permission\Models\Role;
use App\Models\User;
use Illuminate\Support\Facades\Schema;

class EnsureSuperAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function handle(Request $request, Closure $next)
    {
        // Check if the 'users' table exists before proceeding
        if (!Schema::hasTable('users')) {
            // If the 'users' table does not exist, skip this middleware
            return $next($request);
        }
    
        // Fetch the super admin user (assuming the ID is 1; adjust as needed)
        $superAdminUser = User::find(1);
    
        if ($superAdminUser && !$superAdminUser->hasRole('Super Admin')) {
            $superAdminRole = Role::where('name', 'Super Admin')->first();
            
            if ($superAdminRole) {
                // Restore Super Admin role if lost
                $superAdminUser->assignRole('Super Admin');
            }
        }
    
        return $next($request);
    }
}
