<?php

namespace App\Http\Middleware\App;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CheckInstallation
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // Check if the current request is for the installation route
        if ($request->is('install') || $request->is('install/*')) {
            // Bypass the middleware for installation routes
            return $next($request);
        }
    
        // Check if a database connection is possible
        try {
            DB::connection()->getPdo();
            $tables = DB::select('SHOW TABLES');
            
            // Only redirect if tables exist and the current request is NOT for the homepage or install page
            if (!empty($tables) && !$this->isExcludedRoute($request)) {
                // Redirect only if trying to access the installation page after setup is complete
                if ($request->is('install') || $request->is('install/*')) {
                    // If tables exist, redirect to the homepage to disable the install route
                    return redirect('/');
                }
            }
        } catch (\Exception $e) {
            // Redirect to the installation page if the database connection fails
            return redirect('/install')->with('error', 'Database connection not established. Please set up the database.');
        }
    
        // Check if the migrations table exists (to verify if migrations have been run)
        if (!Schema::hasTable('migrations')) {
            return redirect('/install')->with('error', 'The database is not set up. Please complete the installation process.');
        }
    
        // Proceed to the next request if the installation is complete
        return $next($request);
    }

    /**
     * Determine if the current route is excluded from the middleware logic.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return bool
     */
    protected function isExcludedRoute($request)
    {
        // List of paths to exclude from redirection
        return $request->is('/') || $request->is('install*') || $request->is('admin*') || $request->is('frontend*');
    }
}