<?php

namespace App\Http\Controllers\System;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Log;

class ClearOptimizeController extends Controller
{
    public function clearOptimize()
    {
        // Log the start of the Artisan command
        Log::info('ClearOptimizeController: Triggering Artisan command clear:optimize');

        // Run the artisan command and capture the exit code (integer)
        $exitCode = Artisan::call('clear:optimize');

        // Get the output from the Artisan command (all the messages it produced)
        $output = Artisan::output();

        // Log the output for debugging purposes
        Log::info('ClearOptimizeController: Artisan command output: ' . $output);

        // Return a thank you message
        return response()->json([
            'message' => 'Thank you! All caches have been cleared and the app is optimized.',
            'output' => $output,  // Captured output from Artisan::output()
            'exit_code' => $exitCode,  // Exit code (0 = success, 1 = failure)
        ]);
    }
}
