<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Neighborhood;

class NeighborhoodController extends Controller
{
    // Display a list of neighborhoods
    public function index()
    {
        $neighborhoods = Neighborhood::with('district', 'students')->get();
        return view('dashboard.neighborhoods.index', compact('neighborhoods'));
    }

    // Show form to create a new neighborhood
    public function create()
    {
        $districts = District::all();
        return view('dashboard.neighborhoods.create', compact('districts'));
    }

    // Store a new neighborhood
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'district_id' => 'required|exists:districts,id',
        ]);

        Neighborhood::create($validated);
        return redirect()->route('neighborhoods.index');
    }

    // Show a single neighborhood
    public function show(Neighborhood $neighborhood)
    {
        // View neighborhood details
        return view('dashboard.neighborhoods.show', compact('neighborhood'));
    }

    // Show form to edit an existing neighborhood
    public function edit(Neighborhood $neighborhood)
    {
        $districts = District::all();
        return view('dashboard.neighborhoods.edit', compact('neighborhood', 'districts'));
    }

    // Update an existing neighborhood
    public function update(Request $request, Neighborhood $neighborhood)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'district_id' => 'required|exists:districts,id',
        ]);

        $neighborhood->update($validated);
        return redirect()->route('neighborhoods.index');
    }

    // Restrict deletion if there are students under the neighborhood
    public function destroy(Neighborhood $neighborhood)
    {
        if ($neighborhood->students()->count() > 0) {
            return redirect()->route('neighborhoods.index')->with('error', 'Cannot delete a neighborhood that has students assigned to it.');
        }

        $neighborhood->delete();
        return redirect()->route('neighborhoods.index')->with('success', 'Neighborhood deleted successfully.');
    }
}