<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Announcement;

class HomeController extends Controller
{
	public function index()
	{
		$user = auth()->user();

		// Get announcements for this user (permanent, temporary, and specific to this user)
		$announcements = Announcement::where('is_permanent', true)->orWhere(function ($query) use ($user) {
				$query->whereHas('users', function ($q) use ($user) {
					$q->where('user_id', $user->id);
				})->orWhereNull('end_date')->orWhere('end_date', '>=', now());
			})->get();

		return view('dashboard.pages.static.home', compact('announcements'));
	}
}