<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\District;

class DistrictController extends Controller
{
    // Display a list of districts
    public function index()
    {
        // Retrieve all districts with the count of neighborhoods under each
        $districts = District::withCount('neighborhoods')->get();

        return view('dashboard.districts.index', compact('districts'));
    }

    // Show form to create a new district
    public function create()
    {
        return view('dashboard.districts.create');
    }

    // Store a new district
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
        ]);

        District::create($validated);
        return redirect()->route('districts.index')->with('success', 'District created successfully.');
    }

    // Show form to edit an existing district
    public function edit(District $district)
    {
        return view('dashboard.districts.edit', compact('district'));
    }

    // Update an existing district
    public function update(Request $request, District $district)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
        ]);

        $district->update($validated);
        return redirect()->route('districts.index')->with('success', 'District updated successfully.');
    }

    // Show a single neighborhood
    public function show(District $district)
    {
        // Load the districts
        $students = $district->neighborhoods();

        // Pass the grade and paginated students to the view
        return view('dashboard.districts.show', compact('district'));
    }

    // Delete a district
    public function destroy(District $district)
    {
        // Check if the district has any neighborhoods associated with it
        if ($district->neighborhoods()->count() > 0) {
            // Redirect back with an error message if neighborhoods are present
            return redirect()->route('districts.index')->with('error', 'Cannot delete a district that has neighborhoods assigned to it.');
        }

        // If no neighborhoods, delete the district
        $district->delete();

        // Redirect back with a success message
        return redirect()->route('districts.index')->with('success', 'District deleted successfully.');
    }
}
