<?php $__env->startSection('title', isset($user) ? 'Edit User' : 'Create User'); ?>

<?php $__env->startSection('content'); ?>
    <form action="<?php echo e(isset($user) ? route('admin.users.update', ['user', $user->id]) : route('admin.users.store')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <?php if(isset($user)): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>

        <div class="col-12 col-lg-8">
            <!-- User Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0"><?php echo e(isset($user) ? 'Edit User' : 'Create User'); ?></h5>
                </div>

                <div class="card-body">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <div class="mb-3">
                        <label class="form-label" for="full-name">Full Name</label>
                        
                        <input type="text" class="form-control" id="full-name" placeholder="Full Name" name="name" aria-label="Full Name" value="<?php echo e($user->name ?? old('name')); ?>" required />
                        
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red; font-weight: bold"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="email-address">Email Address</label>
                        
                        <input type="email" class="form-control" id="email-address" placeholder="Email Address" name="email" aria-label="Email Address" value="<?php echo e($user->email ?? old('email')); ?>" required />
                        
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red; font-weight: bold"> <?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="roles">Gender</label>
                        <select class="form-control" id="gender" name="gender">
                            <option value="male" <?php if(isset($user) && $user->gender == 'male'): ?> selected <?php endif; ?>>Male</option>
                            <option value="female" <?php if(isset($user) && $user->gender == 'female'): ?> selected <?php endif; ?>>Female</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="phone">Phone</label>
                        <input type="text" class="form-control" id="phone" name="phone" value="<?php echo e($user->phone ?? old('phone')); ?>">
                    </div>
        
                    <div class="mb-3">
                        <label for="photo">Photo</label>

                        <input type="file" class="form-control-file" id="photo" name="photo">

                        <?php if(isset($user) && $user->photo): ?>
                            <img src="<?php echo e(asset('images/' . $user->photo)); ?>" width="100" alt="User Photo">
                        <?php endif; ?>
                    </div>

                    <!-- Roles Select -->
                    <!-- Super Admin role should not be removed -->
                    <?php if(!$user->hasRole('Super Admin')): ?>
                        <div class="mb-3">
                            <label for="roles">Assign Roles</label>
                            <select class="form-control" id="roles" name="roles[]" multiple>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($role->id); ?>" <?php if(isset($user) && $user->roles->contains($role->id)): ?> selected <?php endif; ?>>
                                        <?php echo e($role->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    <?php else: ?>
                        <div class="mb-3">
                            <label for="roles">Assigned Roles</label>
                            <input type="text" class="form-control" value="Super Admin" disabled>
                            <input type="hidden" name="roles[]" value="<?php echo e($superAdminRole->id); ?>">
                        </div>
                    <?php endif; ?>

                    <div class="mb-3">
                        <label for="roles">About you (optional - but you can write small biography so your collegues know more of yourself)</label>
                        <textarea class="form-control" id="about" name="about"><?php echo e($user->about ?? old('about')); ?></textarea>
                    </div>

                    <div class="mb-3">
                        <label for="position">Position</label>
                        <input type="text" name="position" class="form-control" value="<?php echo e($user->position ?? old('position')); ?>">
                    </div>

                    <div class="mb-3">
                        <label for="hired_date">Hired Date</label>
                        <input type="date" name="hired_date" class="form-control" value="<?php echo e($user->hired_date ?? old('hired_date')); ?>">
                    </div>

                    <div class="mb-3">
                        <label for="department">Department</label>
                        <input type="text" name="department" class="form-control" value="<?php echo e($user->department ?? old('department')); ?>">
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-check me-1"></span> <?php echo e(isset($user) ? 'Update' : 'Create'); ?> User
                </button>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\users\form.blade.php ENDPATH**/ ?>