<?php $__env->startSection('title', 'Announcements'); ?>

<?php $__env->startSection('content'); ?>
    <h4>All Announcements</h4>

    <div class="card">
        <h5 class="card-header">Announcements Table</h5>

        <div class="card-body">
            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Title</th>
                            <th>Type</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $announcements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $announcement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($announcement->name); ?></td>
                                <td><?php echo e($announcement->type); ?></td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <a class="dropdown-item" href="<?php echo e(route('admin.announcements.edit', $announcement->id)); ?>">
                                            <i class="ti ti-pencil me-1"></i>
                                            Edit
                                        </a>
                                        
                                        <form action="<?php echo e(route('admin.announcements.destroy', $announcement->id)); ?>" method="POST" style="display:inline;" id="deleteForm<?php echo e($announcement->id); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>

                                            <button type="submit" class="dropdown-item btn btn-danger" onclick="confirmDelete('<?php echo e($announcement->id); ?>')">
                                                <i class="ti ti-trash me-1"></i>
                                                Delete
                                            </button>
                                        </form>
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(announcementId) {
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this announcement! There might be related employees to this announcement',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete it!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + schoolId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                    
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\announcements\index.blade.php ENDPATH**/ ?>