

<?php $__env->startSection('title', 'Sent Invitations'); ?>

<?php $__env->startSection('content'); ?>

    <div class="card">
        <h5 class="card-header">Sent Invitations</h5>

        <div class="card-body">
            <table class="table table-bordered table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Token</th>
                        <th>Status</th>
                        <th>Accepted By</th>
                        <th>Sent Date</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $invitations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invitation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($invitation->name ?? 'N/A'); ?></td> <!-- Display name if available -->
                            <td><?php echo e($invitation->email); ?></td>
                            <td><small><?php echo e($invitation->token); ?></small></td>
                            <td><?php echo e(ucfirst($invitation->status)); ?></td>
                            <td>
                                <?php if($invitation->status == 'accepted' && $invitation->user): ?>
                                    <a href="<?php echo e(route('users.show', $invitation->user->id)); ?>"><?php echo e($invitation->user->name); ?></a>
                                <?php else: ?>
                                    ---
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($invitation->created_at->format('Y-m-d')); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\invitations\index.blade.php ENDPATH**/ ?>