<?php $__env->startSection('title', 'Pages'); ?>

<?php $__env->startSection('content'); ?>
    <h4>All Pages</h4>

    <div class="card">
        <h5 class="card-header">Pages Table</h5>

        <div class="card-body">
            <!-- Display success or error messages -->
            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Title</th>
                            <th>Status</th>
                            <th>Created At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($page->title); ?></td>
                                <td><?php echo e(ucfirst($page->status)); ?></td>
                                <td><?php echo e($page->created_at->format('Y-m-d H:i:s')); ?></td>
                                <td>
                                    <div class="dropdown">
										<button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>
                                    
                                        <div class="dropdown-menu">
											<a class="dropdown-item" href="<?php echo e(route('admin.pages.edit', $page->slug)); ?>">
												<i class="ti ti-pencil me-1"></i>
												Show
											</a>

											<a class="dropdown-item" href="<?php echo e(route('admin.pages.edit', $page->id)); ?>">
												<i class="ti ti-pencil me-1"></i>
												Edit
											</a>

											<?php if(!$page->trashed()): ?>
												<form action="<?php echo e(route('admin.pages.destroy', $page)); ?>" method="POST" id="deleteForm<?php echo e($page->id); ?>" style="display:inline-block;">
													<?php echo csrf_field(); ?>

													<?php echo method_field('DELETE'); ?>

													<button type="submit" class="btn btn-danger" onclick="confirmDelete(event, '<?php echo e($page->id); ?>')">Delete</button>
												</form>
											<?php else: ?>
												<form action="<?php echo e(route('admin.pages.restore', $page->id)); ?>" method="POST" style="display:inline-block;">
													<?php echo csrf_field(); ?>

													<button type="submit" class="btn btn-info">Restore</button>
												</form>

												<form action="<?php echo e(route('admin.pages.forceDelete', $page->id)); ?>" method="POST" id="deleteForm<?php echo e($page->id); ?>" style="display:inline-block;">
													<?php echo csrf_field(); ?>

													<?php echo method_field('DELETE'); ?>

													<button type="submit" class="btn btn-danger" onclick="confirmDelete(event, '<?php echo e($page->id); ?>')">Force Delete</button>
												</form>
											<?php endif; ?>
										</div>
									</div>
									
                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(event, pageId) {
                                            // Prevent the default form submission
                                            event.preventDefault();

                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this page',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete it!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + pageId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\pages\dynamic\index.blade.php ENDPATH**/ ?>