<?php
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'الرئيسية'); ?>

<!-- Vendor Styles -->
<?php $__env->startSection('vendor-style'); ?>
<?php echo app('Illuminate\Foundation\Vite')([
  'resources/assets/vendor/libs/nouislider/nouislider.scss',
  'resources/assets/vendor/libs/swiper/swiper.scss'
]); ?>
<?php $__env->stopSection(); ?>

<!-- Page Styles -->
<?php $__env->startSection('page-style'); ?>
<?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/scss/pages/front-page-landing.scss']); ?>
<?php $__env->stopSection(); ?>

<!-- Vendor Scripts -->
<?php $__env->startSection('vendor-script'); ?>
<?php echo app('Illuminate\Foundation\Vite')([
  'resources/assets/vendor/libs/nouislider/nouislider.js',
  'resources/assets/vendor/libs/swiper/swiper.js'
]); ?>
<?php $__env->stopSection(); ?>

<!-- Page Scripts -->
<?php $__env->startSection('page-script'); ?>
<?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/front-page-landing.js']); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<div data-bs-spy="scroll" class="scrollspy-example">
  <!-- Hero: Start -->
  <section id="hero-animation">
    <div id="landingHero" class="section-py position-relative" style="padding:10rem !important;background-size: cover !important;background-image:url(<?php echo e(asset('assets/img/website/home/hero.jpg')); ?>) !important;">
      <img src="<?php echo e(asset('assets/img/front-pages/backgrounds/hero-bg.png')); ?>" alt="hero background" class="position-absolute top-0 start-50 translate-middle-x object-fit-contain w-100 h-100" data-speed="1"/>
      <div class="container">
        <div class="hero-text-box text-center">
          <h1 class="text-primary hero-title display-6 fw-bold">مختبر خلود للتحاليل الطبية</h1>
          <h2 class="hero-sub-title h6 mb-4 pb-1">
            احصل على نتائج تحاليلك الطبية بسرعة ودقة عالية من خلال أحدث التقنيات المخبرية<br class="d-none d-lg-block" />
            لأن صحتك تهمنا، نقدم لك خدمات موثوقة وأمنة.
          </h2>
          <div class="landing-hero-btn d-inline-block position-relative">
            <a href="#landingPricing" class="btn btn-primary btn-lg">ابدأ الاَن</a>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- Hero: End -->

  <section class="lab-section">
    <div class="container">
        <div class="row gy-4">
            <div class="col-lg-7 text-content">
                <div class="card">
                    <div class="card-body">
                        <h3>مرحباً بك فى موقع مختبر خلود للتحاليل الطبية </h3>
                        <p>نحرص في <strong>مختبر خلود للتحاليل الطبية</strong> على تقديم خدمة مخبرية متكاملة تتميز بالدقة والاحترافية.</p>
                        <p>نسعى دوماً إلى تحقيق أعلى معايير الجودة في جميع تحاليلنا المخبرية، مستندين إلى أحدث التقنيات الطبية لضمان نتائج موثوقة ودقيقة.</p>
                        <p>نفخر بثقة عملائنا الكرام الذين منحونا فرصة خدمتهم، ونسعى جاهدين لنكون خيارهم الأول عند الحاجة إلى فحوصات مخبرية معتمدة.
                        كما نلتزم بتقديم تجربة فريدة، تتميز بسرعة الأداء ودقة التشخيص، لضمان راحة عملائنا ورضاهم التام عن خدماتنا.</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-5 image-content">
                <img src="<?php echo e(asset('assets/img/website/home/welcome.jpg')); ?>" alt="مختبر التحاليل الطبية" class="contact-img w-100 scaleX-n1-rtl">
            </div>
        </div>
    </div>
</section>

<style>
    .lab-section {
        background-color: #f7f7f7;
        padding: 60px 20px;
        text-align: center;
    }
    .text-content {
        min-width: 300px;
        padding: 20px;
    }
    .text-content h3 {
        color: #8a163d;
        font-size: 26px;
        margin-bottom: 15px;
        text-align: right;
    }
    .text-content p {
        font-size: 18px;
        line-height: 1.8;
        color: #333;
        text-align: right;
    }
    .image-content {
        min-width: 300px;
        text-align: center;
        padding: 20px;
    }
    .image-content img {
        width: 100%;
        max-width: 500px;
        border-radius: 10px;
        box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.2);
    }
    
    @media (max-width: 768px) {
        .text-content, .image-content {
            padding: 15px;
        }
        .text-content h3 {
            font-size: 22px;
        }
        .text-content p {
            font-size: 16px;
        }
    }
</style>

<!-- Lab Features: Start -->
<section id="labFeatures" class="section-py lab-features">
    <div class="container">
    <div class="text-center mb-3 pb-1">
        <span class="badge bg-label-primary">لماذا تختار مختبر خلود للتحاليل الطبية؟</span>
    </div>
    <h3 class="text-center mb-1">
        <span class="position-relative fw-bold z-1">نقدم لك خدمات طبية موثوقة
        <img src="<?php echo e(asset('assets/img/front-pages/icons/section-title-icon.png')); ?>" alt="medical icon" class="section-title-img position-absolute object-fit-contain bottom-0 z-n1">
        </span>
        بمعايير عالية الجودة
    </h3>
    <p class="text-center mb-3 mb-md-5 pb-3">
        نحرص على تقديم أدق التحاليل المخبرية باستخدام أحدث الأجهزة الطبية لضمان نتائج موثوقة وسريعة.
    </p>
    <div class="features-icon-wrapper row gx-0 gy-4 g-sm-5">
        <div class="col-lg-4 col-sm-6 text-center features-icon-box">
        <div class="text-center mb-3">
            <img src="<?php echo e(asset('assets/img/website/home/icons/experiment.png')); ?>" alt="microscope" />
        </div>
        <h5 class="mb-3">دقة التحاليل</h5>
        <p class="features-icon-description">
            نقدم نتائج دقيقة وموثوقة بفضل أحدث التقنيات الطبية.
        </p>
        </div>
        <div class="col-lg-4 col-sm-6 text-center features-icon-box">
        <div class="text-center mb-3">
            <img src="<?php echo e(asset('assets/img/website/home/icons/gloves.png')); ?>" alt="fast service" />
        </div>
        <h5 class="mb-3">سرعة الإنجاز</h5>
        <p class="features-icon-description">
            توفير نتائج التحاليل في أسرع وقت ممكن دون المساس بالدقة.
        </p>
        </div>
        <div class="col-lg-4 col-sm-6 text-center features-icon-box">
        <div class="text-center mb-3">
            <img src="<?php echo e(asset('assets/img/website/home/icons/test-tube.png')); ?>" alt="quality" />
        </div>
        <h5 class="mb-3">معايير الجودة</h5>
        <p class="features-icon-description">
            نلتزم بأعلى معايير الجودة لضمان أدق النتائج.
        </p>
        </div>
        <div class="col-lg-4 col-sm-6 text-center features-icon-box">
        <div class="text-center mb-3">
            <img src="<?php echo e(asset('assets/img/website/home/icons/doctor.png')); ?>" alt="customer service" />
        </div>
        <h5 class="mb-3">خدمة العملاء</h5>
        <p class="features-icon-description">
            فريق دعم متاح للإجابة على استفساراتك ومساعدتك في كل الأوقات.
        </p>
        </div>
        <div class="col-lg-4 col-sm-6 text-center features-icon-box">
        <div class="text-center mb-3">
            <img src="<?php echo e(asset('assets/img/website/home/icons/microbiology.png')); ?>" alt="medical report" />
        </div>
        <h5 class="mb-3">تقارير طبية دقيقة</h5>
        <p class="features-icon-description">
            توفير تقارير تفصيلية وسهلة الفهم لضمان وضوح النتائج.
        </p>
        </div>
        <div class="col-lg-4 col-sm-6 text-center features-icon-box">
        <div class="text-center mb-3">
            <img src="<?php echo e(asset('assets/img/website/home/icons/laboratory-device.png')); ?>" alt="home service" />
        </div>
        <h5 class="mb-3">خدمة التحاليل المنزلية</h5>
        <p class="features-icon-description">
            نوفر إمكانية أخذ العينات من المنزل براحة وأمان.
        </p>
        </div>
    </div>
    </div>
  </section>
  <!-- Lab Features: End -->

  <div class="modal fade" id="offer1" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
      <div class="modal-content p-3 p-md-5">
        <div class="modal-body">
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          <div class="text-center mb-4">
            <img src="<?php echo e(asset('assets/img/website/home/offers/1.jpg')); ?>" alt="" class="img-fluid" />
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="offer2" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
      <div class="modal-content p-3 p-md-5">
        <div class="modal-body">
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          <div class="text-center mb-4">
            <img src="<?php echo e(asset('assets/img/website/home/offers/2.jpg')); ?>" alt="" class="img-fluid" />
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="offer3" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
      <div class="modal-content p-3 p-md-5">
        <div class="modal-body">
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          <div class="text-center mb-4">
            <img src="<?php echo e(asset('assets/img/website/home/offers/3.jpg')); ?>" alt="" class="img-fluid" />
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="offer4" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
      <div class="modal-content p-3 p-md-5">
        <div class="modal-body">
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          <div class="text-center mb-4">
            <img src="<?php echo e(asset('assets/img/website/home/offers/4.jpg')); ?>" alt="" class="img-fluid" />
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="offer5" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
      <div class="modal-content p-3 p-md-5">
        <div class="modal-body">
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          <div class="text-center mb-4">
            <img src="<?php echo e(asset('assets/img/website/home/offers/5.jpg')); ?>" alt="" class="img-fluid" />
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="offer6" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
      <div class="modal-content p-3 p-md-5">
        <div class="modal-body">
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          <div class="text-center mb-4">
            <img src="<?php echo e(asset('assets/img/website/home/offers/6.jpg')); ?>" alt="" class="img-fluid" />
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="offer7" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
      <div class="modal-content p-3 p-md-5">
        <div class="modal-body">
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          <div class="text-center mb-4">
            <img src="<?php echo e(asset('assets/img/website/home/offers/7.jpg')); ?>" alt="" class="img-fluid" />
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="offer8" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
      <div class="modal-content p-3 p-md-5">
        <div class="modal-body">
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          <div class="text-center mb-4">
            <img src="<?php echo e(asset('assets/img/website/home/offers/8.jpg')); ?>" alt="" class="img-fluid" />
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="offer9" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
      <div class="modal-content p-3 p-md-5">
        <div class="modal-body">
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          <div class="text-center mb-4">
            <img src="<?php echo e(asset('assets/img/website/home/offers/9.jpg')); ?>" alt="" class="img-fluid" />
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="offer10" tabindex="-1" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered1 modal-simple modal-add-new-cc">
      <div class="modal-content p-3 p-md-5">
        <div class="modal-body">
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          <div class="text-center mb-4">
            <img src="<?php echo e(asset('assets/img/website/home/offers/10.jpg')); ?>" alt="" class="img-fluid" />
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Real customers reviews: Start -->
  <section id="landingReviews" class="section-py bg-body landing-reviews pb-0">
    <!-- What people say slider: Start -->
    <div class="container">
      <div class="row align-items-center gx-0 gy-4 g-lg-5">
        <div class="col-md-6 col-lg-5 col-xl-3">
          <div class="mb-3 pb-1">
            <span class="badge bg-label-primary">عروض الحالية</span>
          </div>
          <h3 class="mb-1">
            <span class="position-relative fw-bold z-1">تواصل معنا الآن لحجز موعدك والاستفادة من هذه العروض الحصرية!
              <img src="<?php echo e(asset('assets/img/front-pages/icons/section-title-icon.png')); ?>" alt="laptop charging" class="section-title-img position-absolute object-fit-contain bottom-0 z-n1">
            </span>
          </h3>
          <p class="mb-3 mb-md-5">
            رضاك هو مؤشر نجاحنا وأولويتنا<br class="d-none d-xl-block" />
            ترك انطباع لديك بأنك العميل الأهم.
          </p>
          <div class="landing-reviews-btns" style="direction: ltr;">
            <button id="reviews-previous-btn" class="btn btn-label-primary reviews-btn me-3 scaleX-n1-rtl" type="button">
              <i class="ti ti-chevron-left ti-sm"></i>
            </button>
            <button id="reviews-next-btn" class="btn btn-label-primary reviews-btn scaleX-n1-rtl" type="button">
              <i class="ti ti-chevron-right ti-sm"></i>
            </button>
          </div>
        </div>
        <div class="col-md-6 col-lg-7 col-xl-9">
          <div class="swiper-reviews-carousel overflow-hidden mb-5 pb-md-2 pb-md-3">
            <div class="swiper" id="swiper-reviews">
              <div class="swiper-wrapper">
                <div class="swiper-slide">
                  <div class="card h-100">
                    <div class="card-body text-body d-flex flex-column justify-content-between h-100">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#offer1">
                            <img src="<?php echo e(asset('assets/img/website/home/offers/1.jpg')); ?>" alt="" class="img-fluid" />
                        </a>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                    <div class="card h-100">
                      <div class="card-body text-body d-flex flex-column justify-content-between h-100">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#offer2">
                            <img src="<?php echo e(asset('assets/img/website/home/offers/2.jpg')); ?>" alt="" class="img-fluid" />
                        </a>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="card h-100">
                      <div class="card-body text-body d-flex flex-column justify-content-between h-100">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#offer3">
                          <img src="<?php echo e(asset('assets/img/website/home/offers/3.jpg')); ?>" alt="" class="img-fluid" />
                        </a>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="card h-100">
                      <div class="card-body text-body d-flex flex-column justify-content-between h-100">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#offer4">
                          <img src="<?php echo e(asset('assets/img/website/home/offers/4.jpg')); ?>" alt="" class="img-fluid" />
                        </a>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="card h-100">
                      <div class="card-body text-body d-flex flex-column justify-content-between h-100">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#offer5">
                          <img src="<?php echo e(asset('assets/img/website/home/offers/5.jpg')); ?>" alt="" class="img-fluid" />
                        </a>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="card h-100">
                      <div class="card-body text-body d-flex flex-column justify-content-between h-100">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#offer6">
                          <img src="<?php echo e(asset('assets/img/website/home/offers/6.jpg')); ?>" alt="" class="img-fluid" />
                        </a>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="card h-100">
                      <div class="card-body text-body d-flex flex-column justify-content-between h-100">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#offer7">
                          <img src="<?php echo e(asset('assets/img/website/home/offers/7.jpg')); ?>" alt="" class="img-fluid" />
                        </a>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="card h-100">
                      <div class="card-body text-body d-flex flex-column justify-content-between h-100">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#offer8">
                          <img src="<?php echo e(asset('assets/img/website/home/offers/8.jpg')); ?>" alt="" class="img-fluid" />
                        </a>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="card h-100">
                      <div class="card-body text-body d-flex flex-column justify-content-between h-100">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#offer9">
                          <img src="<?php echo e(asset('assets/img/website/home/offers/9.jpg')); ?>" alt="" class="img-fluid" />
                        </a>
                      </div>
                    </div>
                  </div>
                  <div class="swiper-slide">
                    <div class="card h-100">
                      <div class="card-body text-body d-flex flex-column justify-content-between h-100">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#offer10">
                          <img src="<?php echo e(asset('assets/img/website/home/offers/10.jpg')); ?>" alt="" class="img-fluid" />
                        </a>
                      </div>
                    </div>
                  </div>
              </div>
              <div class="swiper-button-next"></div>
              <div class="swiper-button-prev"></div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- What people say slider: End -->
    <hr class="m-0" />
    <!-- Logo slider: Start -->
    <div class="container">
      <div class="swiper-logo-carousel py-4 my-lg-2">
        <div class="swiper" id="swiper-clients-logos">
          <div class="swiper-wrapper">
            <div class="swiper-slide">
              <img src="<?php echo e(asset('assets/img/front-pages/branding/logo_1-'.$configData['style'].'.png')); ?>" alt="client logo" class="client-logo" data-app-light-img="front-pages/branding/logo_1-light.png" data-app-dark-img="front-pages/branding/logo_1-dark.png" />
            </div>
            <div class="swiper-slide">
              <img src="<?php echo e(asset('assets/img/front-pages/branding/logo_2-'.$configData['style'].'.png')); ?>" alt="client logo" class="client-logo" data-app-light-img="front-pages/branding/logo_2-light.png" data-app-dark-img="front-pages/branding/logo_2-dark.png" />
            </div>
            <div class="swiper-slide">
              <img src="<?php echo e(asset('assets/img/front-pages/branding/logo_3-'.$configData['style'].'.png')); ?>" alt="client logo" class="client-logo" data-app-light-img="front-pages/branding/logo_3-light.png" data-app-dark-img="front-pages/branding/logo_3-dark.png" />
            </div>
            <div class="swiper-slide">
              <img src="<?php echo e(asset('assets/img/front-pages/branding/logo_4-'.$configData['style'].'.png')); ?>" alt="client logo" class="client-logo" data-app-light-img="front-pages/branding/logo_4-light.png" data-app-dark-img="front-pages/branding/logo_4-dark.png" />
            </div>
            <div class="swiper-slide">
              <img src="<?php echo e(asset('assets/img/front-pages/branding/logo_5-'.$configData['style'].'.png')); ?>" alt="client logo" class="client-logo" data-app-light-img="front-pages/branding/logo_5-light.png" data-app-dark-img="front-pages/branding/logo_5-dark.png" />
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- Logo slider: End -->
  </section>
  <!-- Real customers reviews: End -->

  <!-- Our great team: Start -->
  <section id="landingTeam" class="section-py landing-team">
    <div class="container">
      <div class="text-center mb-3 pb-1">
        <span class="badge bg-label-primary">برامج المختبر</span>
      </div>
      <h3 class="text-center mb-1">
        <span class="position-relative fw-bold z-1">برامج
          <img src="<?php echo e(asset('assets/img/front-pages/icons/section-title-icon.png')); ?>" alt="laptop charging" class="section-title-img position-absolute object-fit-contain bottom-0 z-n1">
        </span>
        الفحص لدينا دقة وموثوقية لصحتك</h3>
      <p class="text-center mb-md-5 pb-3">نوفر لك في مختبر خلود للتحاليل الطبية مجموعة متنوعة من الباقات المصممة لتلبية احتياجاتك الصحية،<br> بدءًا من الفحوصات الدورية وحتى التحاليل المتخصصة، بجودة عالية ومعايير طبية دقيقة</p>
      <div class="row mb-5">
        <div class="col-md-6 col-xl-3">
            <div class="card mb-3">
              <img class="card-img-top" src="<?php echo e(asset('assets/img/website/home/programs/laboratory-test.jpg')); ?>" alt="Card image cap">
              <div class="card-body">
                <h5 class="card-title">برنامج الفحص الشامل</h5>
                <p class="card-text">
                    يقدم فحصاً شاملاً للصحة العامة يتضمن مجموعة من التحاليل الأساسية للكشف المبكر عن الأمراض وضمان صحة أجهزة الجسم المختلفة
                </p>
                <p class="card-text">
                  <small class="text-muted">500 ريال</small>
                  <a href="#" class="btn btn-primary float-end">اشترك الاَن</a>
                </p>
              </div>
            </div>
          </div>
          <div class="col-md-6 col-xl-3">
            <div class="card mb-3">
              <img class="card-img-top" src="<?php echo e(asset('assets/img/website/home/programs/diabetes.jpg')); ?>" alt="Card image cap">
              <div class="card-body">
                <h5 class="card-title">برنامج متابعة السكري</h5>
                <p class="card-text">
                    يتضمن فحوصات دورية لمراقبة مستوى السكر في الدم وتحليل الهيموجلوبين السكري، بالإضافة إلى فحوصات مهمة لمتابعة حالة مرضى السكري
                </p>
                <p class="card-text">
                  <small class="text-muted">320 ريال</small>
                  <a href="#" class="btn btn-primary float-end">اشترك الاَن</a>
                </p>
              </div>
            </div>
          </div>
          <div class="col-md-6 col-xl-3">
            <div class="card mb-3">
              <img class="card-img-top" src="<?php echo e(asset('assets/img/website/home/programs/person-is-writing-calendar-with-pencil-it.jpg')); ?>" alt="Card image cap">
              <div class="card-body">
                <h5 class="card-title">برنامج فحص الحمل</h5>
                <p class="card-text">
                    يقدم تحاليل شاملة للحوامل لمتابعة صحة الأم والجنين، ويشمل تحاليل الهرمونات والفحوصات الروتينية الأخرى لضمان حمل صحي
                </p>
                <p class="card-text">
                  <small class="text-muted">180 ريال</small>
                  <a href="#" class="btn btn-primary float-end">اشترك الاَن</a>
                </p>
              </div>
            </div>
          </div>
          <div class="col-md-6 col-xl-3">
            <div class="card mb-3">
              <img class="card-img-top" src="<?php echo e(asset('assets/img/website/home/programs/cardiac-test.jpg')); ?>" alt="Card image cap">
              <div class="card-body">
                <h5 class="card-title">برنامج فحص القلب والشرايين</h5>
                <p class="card-text">
                 مجموعة من الفحوصات المتخصصة لصحة القلب والشرايين، تشمل قياس نسبة الدهون والكوليسترول وفحص الهوموسيستين لضمان سلامة الأوعية الدموية
                </p>
                <p class="card-text">
                  <small class="text-muted">780 ريال</small>
                  <a href="#" class="btn btn-primary float-end">اشترك الاَن</a>
                </p>
              </div>
            </div>
          </div>
      </div>
    </div>
  </section>
  <!-- Our great team: End -->

  <!-- Pricing plans: Start -->
  <section id="landingPricing" class="section-py bg-body landing-pricing" style="background-size: cover !important;background-image:url(<?php echo e(asset('assets/img/website/home/lab-equipment-frame-with-copy-space.jpg')); ?>) !important;">
    <div class="container">
      <div class="p-0 mb-4" >
        <div class="d-flex flex-column flex-md-row justify-content-between p-0 pt-4">
          <div class="app-academy-md-50 card-body d-flex align-items-md-center flex-column text-md-center">
            <div class="text-center mb-3 pb-1">
                <span class="badge bg-label-primary">نتائج التحاليل</span>
              </div>
            <h3 class="card-title mb-4 lh-sm px-md-5 lh-lg">
                نوفر لك
              <span class="text-primary fw-medium text-nowrap position-relative fw-bold z-1">
                تقارير مفصلة ودقيقة
                <img src="<?php echo e(asset('assets/img/front-pages/icons/section-title-icon.png')); ?>" alt="laptop charging" class="section-title-img position-absolute object-fit-contain bottom-0 z-n1">
              </span>
              لجميع تحاليلك الطبية عبر موقعنا
            </h3>
            <p class="mb-3">
                الان يمكنك الحصول على نتائج التحاليل من خلال موقعنا بكل سهولة!
            </p>
            <div class="d-flex align-items-center justify-content-between app-academy-md-80">
              <input type="search" placeholder="ادخل رقم التحليل" class="form-control me-2">
              <button type="submit" class="btn btn-primary btn-icon"><i class="ti ti-search"></i></button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- Pricing plans: End -->

  <!-- Fun facts: Start -->
  <section id="landingFunFacts" class="section-py landing-fun-facts">
    <div class="container">
      <div class="row gy-3">
        <div class="col-sm-6 col-lg-3">
          <div class="card border border-label-primary shadow-none">
            <div class="card-body text-center">
              <img src="<?php echo e(asset('assets/img/website/home/icons/microscope.png')); ?>" alt="laptop" class="mb-2" />
              <h5 class="h2 mb-1">100%</h5>
              <p class="fw-medium mb-0">
                دقة نتائج الفحوصات<br />
                نتائج دقيقة ومعتمدة لضمان صحتك
              </p>
            </div>
          </div>
        </div>
        <div class="col-sm-6 col-lg-3">
          <div class="card border border-label-success shadow-none">
            <div class="card-body text-center">
              <img src="<?php echo e(asset('assets/img/website/home/icons/experiment-results.png')); ?>" alt="laptop" class="mb-2" />
              <h5 class="h2 mb-1">4.9/5</h5>
              <p class="fw-medium mb-0">
                تقييم العملاء<br />
                رضا العملاء عن خدماتنا المخبرية
              </p>
            </div>
          </div>
        </div>
        <div class="col-sm-6 col-lg-3">
          <div class="card border border-label-info shadow-none">
            <div class="card-body text-center">
              <img src="<?php echo e(asset('assets/img/website/home/icons/observation.png')); ?>" alt="laptop" class="mb-2" />
              <h5 class="h2 mb-1">+50k</h5>
              <p class="fw-medium mb-0">
                عدد العملاء<br />
                أكثر من 50,000 عميل يثقون بنا
              </p>
            </div>
          </div>
        </div>
        <div class="col-sm-6 col-lg-3">
          <div class="card border border-label-warning shadow-none">
            <div class="card-body text-center">
              <img src="<?php echo e(asset('assets/img/website/home/icons/flask.png')); ?>" alt="laptop" class="mb-2" />
              <h5 class="h2 mb-1">+7.1k</h5>
              <p class="fw-medium mb-0">
                تحاليل مخبرية يومية<br />
                آلاف التحاليل تُجرى يوميًا بأحدث الأجهزة
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- Fun facts: End -->

  <!-- FAQ: Start -->
  <section id="landingFAQ" class="section-py bg-body landing-faq">
    <div class="container">
      <div class="text-center mb-3 pb-1">
        <span class="badge bg-label-primary">الأسئلة الشائعة</span>
      </div>
      <h3 class="text-center mb-1">اجوبة استفسارات
        <span class="position-relative fw-bold z-1">تهمك
          <img src="<?php echo e(asset('assets/img/front-pages/icons/section-title-icon.png')); ?>" alt="laptop charging" class="section-title-img position-absolute object-fit-contain bottom-0 z-n1">
        </span>
      </h3>
      <p class="text-center mb-5 pb-3">تصفح هذه الأسئلة الشائعة للعثور على إجابات للاستفسارات المتداولة. </p>
      <div class="row gy-5">
        <div class="col-lg-5">
          <div class="text-center">
            <img src="<?php echo e(asset('assets/img/website/home/faq.jpg')); ?>" alt="faq boy with logos" class="faq-image" style="max-width: unset !important; width: 100%;" />
          </div>
        </div>
        <div class="col-lg-7">
          <div class="accordion" id="accordionExample">
            <div class="card accordion-item active">
              <h2 class="accordion-header" id="headingOne">
                <button type="button" class="accordion-button" data-bs-toggle="collapse" data-bs-target="#accordionOne" aria-expanded="true" aria-controls="accordionOne">
                    ما هي أنواع التحاليل التي يقدمها المختبر؟
                </button>
              </h2>

              <div id="accordionOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    نقدم مجموعة واسعة من التحاليل الطبية بما في ذلك تحاليل الدم، البول، الهرمونات، والأمراض المعدية.
                </div>
              </div>
            </div>
            <div class="card accordion-item">
              <h2 class="accordion-header" id="headingTwo">
                <button type="button" class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#accordionTwo" aria-expanded="false" aria-controls="accordionTwo">
                    هل أحتاج إلى موعد مسبق لإجراء التحاليل؟
                </button>
              </h2>
              <div id="accordionTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    ننصح بحجز موعد مسبق لتسهيل العملية، ولكننا نستقبل أيضًا الحالات بدون موعد.
                </div>
              </div>
            </div>
            <div class="card accordion-item">
              <h2 class="accordion-header" id="headingThree">
                <button type="button" class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#accordionThree" aria-expanded="false" aria-controls="accordionThree">
                    كم من الوقت تستغرق نتائج التحاليل؟
                </button>
              </h2>
              <div id="accordionThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    تختلف مدة ظهور النتائج حسب نوع التحليل، ولكن معظم النتائج تكون جاهزة خلال 24-48 ساعة.
                </div>
              </div>
            </div>
            <div class="card accordion-item">
              <h2 class="accordion-header" id="headingFour">
                <button type="button" class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#accordionFour" aria-expanded="false" aria-controls="accordionFour">
                    هل يمكنني الحصول على نتائج التحاليل عبر الإنترنت؟
                </button>
              </h2>
              <div id="accordionFour" class="accordion-collapse collapse" aria-labelledby="headingFour" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    نعم، نوفر خدمة الحصول على النتائج عبر موقعنا الإلكتروني أو تطبيقنا الخاص.
                </div>
              </div>
            </div>
            <div class="card accordion-item">
              <h2 class="accordion-header" id="headingFive">
                <button type="button" class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#accordionFive" aria-expanded="false" aria-controls="accordionFive">
                    ما هي الإرشادات التي يجب اتباعها قبل إجراء التحاليل؟
                </button>
              </h2>
              <div id="accordionFive" class="accordion-collapse collapse" aria-labelledby="headingFive" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    بعض التحاليل تتطلب الصيام لمدة 8-12 ساعة، وسنقدم لك الإرشادات اللازمة عند حجز الموعد.
                </div>
              </div>
            </div>
            <div class="card accordion-item">
                <h2 class="accordion-header" id="headingSix">
                  <button type="button" class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#accordionSix" aria-expanded="false" aria-controls="accordionSix">
                    هل المختبر مجهز للتعامل مع الحالات الطارئة؟
                  </button>
                </h2>
                <div id="accordionSix" class="accordion-collapse collapse" aria-labelledby="headingSix" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                    نعم، لدينا فريق طبي مدرب ومعدات متطورة للتعامل مع الحالات الطارئة.
                  </div>
                </div>
              </div>
              <div class="card accordion-item">
                <h2 class="accordion-header" id="headingSeven">
                  <button type="button" class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#accordionSeven" aria-expanded="false" aria-controls="accordionSeven">
                    ما هي ساعات عمل المختبر؟
                  </button>
                </h2>
                <div id="accordionSeven" class="accordion-collapse collapse" aria-labelledby="headingSeven" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                    نعمل من الساعة 8 صباحًا حتى 8 مساءً طوال أيام الأسبوع، بما في ذلك العطلات الرسمية.
                  </div>
                </div>
              </div>
              <div class="card accordion-item">
                <h2 class="accordion-header" id="headingEight">
                  <button type="button" class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#accordionEight" aria-expanded="false" aria-controls="accordionEight">
                    هل يمكنني إجراء تحاليل للأطفال في المختبر؟
                  </button>
                </h2>
                <div id="accordionEight" class="accordion-collapse collapse" aria-labelledby="headingEight" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                    نعم، لدينا أخصائيون مدربون للتعامل مع الأطفال وإجراء التحاليل اللازمة لهم.
                  </div>
                </div>
              </div>
              <div class="card accordion-item">
                <h2 class="accordion-header" id="headingNine">
                  <button type="button" class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#accordionNine" aria-expanded="false" aria-controls="accordionNine">
                    ما هي الإجراءات المتبعة لضمان دقة النتائج؟
                  </button>
                </h2>
                <div id="accordionNine" class="accordion-collapse collapse" aria-labelledby="headingNine" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                    نستخدم أحدث التقنيات والمعايير الدولية لضمان دقة وموثوقية النتائج.
                  </div>
                </div>
              </div>
              <div class="card accordion-item">
                <h2 class="accordion-header" id="headingTen">
                  <button type="button" class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#accordionTen" aria-expanded="false" aria-controls="accordionTen">
                    هل يمكنني الحصول على استشارة طبية بعد الحصول على النتائج؟
                  </button>
                </h2>
                <div id="accordionTen" class="accordion-collapse collapse" aria-labelledby="headingTen" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                    نعم، نوفر استشارات طبية مع أخصائيين لتفسير النتائج وتقديم التوصيات اللازمة.
                  </div>
                </div>
              </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- FAQ: End -->

  <!-- CTA: Start -->
  <section id="landingCTA" class="section-py landing-cta position-relative p-lg-7 pb-7" style="background-size: cover !important;background-image:url(<?php echo e(asset('assets/img/website/home/home-visit.jpg')); ?>);">
    <img src="<?php echo e(asset('assets/img/front-pages/backgrounds/cta-bg-'.$configData['style'].'.png')); ?>" class="position-absolute bottom-0 end-0 scaleX-n1-rtl h-100 w-100 z-n1" alt="cta image" data-app-light-img="front-pages/backgrounds/cta-bg-light.png" data-app-dark-img="front-pages/backgrounds/cta-bg-dark.png" />
    <div class="container">
      <div class="row align-items-center gy-5 gy-lg-0">
        <div class="col-lg-6 text-center text-lg-start">
          <h6 class="h2 text-primary fw-bold mb-1">أحجز الأن زيارة منزلية</h6>
          <p class="fw-medium mb-4">تقدر تسوي التحاليل وانت فمكانك بس احجز زيارة منزلية ونوصل لك لأي مكان</p>
          <a href="<?php echo e(url('/front-pages/payment')); ?>" class="btn btn-lg btn-primary">سجل الآن</a>
        </div>
        
      </div>
    </div>
  </section>
  <!-- CTA: End -->

  <!-- Contact Us: Start -->
  <section id="landingContact" class="section-py bg-body landing-contact">
    <div class="container">
      <div class="text-center mb-3 pb-1">
        <span class="badge bg-label-primary">اتصل بنا الاَن</span>
      </div>
      <h3 class="text-center mb-1">
        <span class="position-relative fw-bold z-1">نرحب دائماً بتواصلكم
          <img src="<?php echo e(asset('assets/img/front-pages/icons/section-title-icon.png')); ?>" alt="laptop charging" class="section-title-img position-absolute object-fit-contain bottom-0 z-n1">
        </span>
        معنا
      </h3>
      <p class="text-center mb-4 mb-lg-5 pb-md-3">لديك أي استفسار أو ملاحظة؟ فقط أرسل لنا رسالة</p>
      <div class="row gy-4">
        <div class="col-lg-5">
          <div class="contact-img-box position-relative border p-2 h-100">
            <img src="<?php echo e(asset('assets/img/front-pages/icons/contact-border.png')); ?>" alt="contact border" class="contact-border-img position-absolute d-none d-md-block scaleX-n1-rtl" />
            <img src="<?php echo e(asset('assets/img/website/home/contact.jpg')); ?>" alt="contact customer service" class="contact-img w-100 scaleX-n1-rtl" />
            <div class="pt-3 px-4 pb-1">
              <div class="row gy-3 gx-md-4">
                <div class="col-md-6 col-lg-12 col-xl-6">
                  <div class="d-flex align-items-center">
                    <div class="badge bg-label-primary rounded p-2 me-2"><i class="ti ti-mail ti-sm"></i></div>
                    <div>
                      <p class="mb-0">البريد الإلكتروني</p>
                      <h5 class="mb-0">
                        <a href="mailto:example@gmail.com" class="text-heading">info@kholoudlab.com</a>
                      </h5>
                    </div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-12 col-xl-6">
                  <div class="d-flex align-items-center">
                    <div class="badge bg-label-success rounded p-2 me-2">
                      <i class="ti ti-phone-call ti-sm"></i>
                    </div>
                    <div>
                      <p class="mb-0">رقم الجوال</p>
                      <h5 class="mb-0"><a href="tel:+966559070400" class="text-heading">966559070400+</a></h5>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-lg-7">
          <div class="card">
            <div class="card-body">
              <h4 class="mb-1">أرسل رسالة الاَن</h4>
              <p class="mb-4">
                إذا كان لديك أي استفسار حول الفحوصات الطبية، التحاليل المخبرية، الأسعار،!<br class="d-none d-lg-block" />
                أو الخدمات المتاحة، فلا تتردد في التواصل معنا. نحن هنا لمساعدتك
              </p>
              <form>
                <div class="row g-3">
                  <div class="col-md-6">
                    <label class="form-label" for="contact-form-fullname">الاسم بالكامل</label>
                    <input type="text" class="form-control" id="contact-form-fullname" placeholder="john" />
                  </div>
                  <div class="col-md-6">
                    <label class="form-label" for="contact-form-email">البريد الإلكتروني</label>
                    <input type="text" id="contact-form-email" class="form-control" placeholder="johndoe@gmail.com" />
                  </div>
                  <div class="col-12">
                    <label class="form-label" for="contact-form-message">محتوى الرسالة</label>
                    <textarea id="contact-form-message" class="form-control" rows="8" placeholder="اكتب رسالتك هنا"></textarea>
                  </div>
                  <div class="col-12">
                    <button type="submit" class="btn btn-primary">إرسال الاستفسار</button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- Contact Us: End -->
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views/front/pages/home.blade.php ENDPATH**/ ?>