<script src="https://cdnjs.cloudflare.com/ajax/libs/pusher/7.0.3/pusher.min.js"></script>

<?php
$menuCollapsed = ($configData['menuCollapsed'] === 'layout-menu-collapsed') ? json_encode(true) : false;
?>

<!-- laravel style -->
<?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/js/helpers.js']); ?>

<!-- beautify ignore:start -->
<?php if($configData['hasCustomizer']): ?>
  <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
  <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  -->
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/js/template-customizer.js']); ?>
<?php endif; ?>

<!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
<?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/config.js']); ?>

<?php if($configData['hasCustomizer']): ?>
    <script type="module">
        window.templateCustomizer = new TemplateCustomizer({
            cssPath: '',
            themesPath: '',
            defaultStyle: "<?php echo e($configData['styleOpt']); ?>",
            defaultShowDropdownOnHover: "<?php echo e($configData['showDropdownOnHover']); ?>", // true/false (for horizontal layout only)
            displayCustomizer: "<?php echo e($configData['displayCustomizer']); ?>",
            lang: '<?php echo e(app()->getLocale()); ?>',
            pathResolver: function(path) {
                var resolvedPaths = {
                    // Core stylesheets
                    <?php $__currentLoopData = ['core']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    '<?php echo e($name); ?>.scss': '<?php echo e(Vite::asset('resources/assets/vendor/scss'.$configData["rtlSupport"].'/'.$name.'.scss')); ?>',
                    '<?php echo e($name); ?>-dark.scss': '<?php echo e(Vite::asset('resources/assets/vendor/scss'.$configData["rtlSupport"].'/'.$name.'-dark.scss')); ?>',
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    // Themes
                    <?php $__currentLoopData = ['default', 'bordered', 'semi-dark']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    'theme-<?php echo e($name); ?>.scss': '<?php echo e(Vite::asset('resources/assets/vendor/scss'.$configData["rtlSupport"].'/theme-'.$name.'.scss')); ?>',
                    'theme-<?php echo e($name); ?>-dark.scss': '<?php echo e(Vite::asset('resources/assets/vendor/scss'.$configData["rtlSupport"].'/theme-'.$name.'-dark.scss')); ?>',
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                }
                return resolvedPaths[path] || path;
            },
            'controls': <?php echo json_encode($configData['customizerControls']); ?>,
        });
    </script>
<?php endif; ?>

<script>
    let idleTime = 0;
    const maxIdleTime = 30; // 30 minutes of inactivity

    // Increment the idle time every minute
    setInterval(timerIncrement, 60000); // 1 minute interval

    // Reset idle time when there is activity
    window.onload = resetTimer;
    window.onmousemove = resetTimer;
    window.onkeypress = resetTimer;

    function resetTimer() {
        idleTime = 0;
    }

    function timerIncrement() {
        idleTime++;
        if (idleTime >= maxIdleTime) {
            // User has been inactive for more than maxIdleTime minutes
            // Send an AJAX request to log the user out or update status
            $.ajax({
                url: '/logout',  // Or a custom route to just update the user's status
                method: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function() {
                    window.location.reload(); // Optionally reload the page after logout
                }
            });
        }
    }
</script>

<script>
    window.Echo.join('user-status')
        .here((users) => {
            console.log('Users currently online:', users);
        })
        .joining((user) => {
            console.log(user.name + ' is now online.');
            // Update the UI to reflect the user is online
            document.getElementById('user-' + user.user_id).innerHTML = 'Online';
        })
        .leaving((user) => {
            console.log(user.name + ' is now offline.');
            // Update the UI to reflect the user is offline
            document.getElementById('user-' + user.user_id).innerHTML = 'Offline';
        })
        .listen('UserOnlineStatusChanged', (e) => {
            console.log('User status changed:', e);
        });
</script><?php /**PATH C:\laragon\www\kholoudlab\resources\views/layouts/sections/scriptsIncludes.blade.php ENDPATH**/ ?>