<?php $__env->startSection('title', 'Lab Tests'); ?>

<?php $__env->startSection('content'); ?>
    <h4>Lab Tests</h4>

    <div class="card">
        <h5 class="card-header">Lab Tests</h5>

        <div class="card-body">
            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Name</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                            <?php $__currentLoopData = $labTests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $labTest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($labTest->name); ?></td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>
                                    
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="<?php echo e(route('admin.lab_tests.edit', $labTest->id)); ?>">
                                                <i class="ti ti-pencil me-1"></i>
                                                Edit
                                            </a>
                                            
                                            <a class="dropdown-item" href="<?php echo e(route('admin.lab_tests.show', $labTest->id)); ?>">
                                                <i class="ti ti-eye me-1"></i>
                                                Show
                                            </a>

                                            <form action="<?php echo e(route('admin.lab_tests.destroy', $labTest->id)); ?>" method="POST" style="display:inline;" id="deleteForm<?php echo e($labTest->id); ?>">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>

                                                <button type="submit" class="dropdown-item btn btn-danger" onclick="confirmDelete('<?php echo e($labTest->id); ?>')">
                                                    <i class="ti ti-trash me-1"></i>
                                                    Delete
                                                </button>
                                            </form>
                                        </div>
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(labTestId) {
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this lab test!',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete it!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + schoolId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                    
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\kholoudlab\resources\views\dashboard\lab_tests\index.blade.php ENDPATH**/ ?>