<!DOCTYPE html>
@php
$menuFixed = ($configData['layout'] === 'vertical') ? ($menuFixed ?? '') : (($configData['layout'] === 'front') ? '' : $configData['headerType']);
$navbarType = ($configData['layout'] === 'vertical') ? ($configData['navbarType'] ?? '') : (($configData['layout'] === 'front') ? 'layout-navbar-fixed': '');
$isFront = ($isFront ?? '') == true ? 'Front' : '';
$contentLayout = (isset($container) ? (($container === 'container-xxl') ? "layout-compact" : "layout-wide") : "");
@endphp

<html lang="{{ session()->get('locale') ?? app()->getLocale() }}" class="{{ $configData['style'] }}-style {{($contentLayout ?? '')}} {{ ($navbarType ?? '') }} {{ ($menuFixed ?? '') }} {{ $menuCollapsed ?? '' }} {{ $menuFlipped ?? '' }} {{ $menuOffcanvas ?? '' }} {{ $footerFixed ?? '' }} {{ $customizerHidden ?? '' }}" dir="{{ $configData['textDirection'] }}" data-theme="{{ $configData['theme'] }}" data-assets-path="{{ asset('/assets') . '/' }}" data-base-url="{{url('/')}}" data-framework="laravel" data-template="{{ $configData['layout'] . '-menu-' . $configData['theme'] . '-' . $configData['styleOpt'] }}">
    <head>
        <meta charset="utf-8" />
        
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

        <title>@yield('title') |
            {{ config('variables.templateName') ? config('variables.templateName') : 'TemplateName' }} -
            {{ config('variables.templateSuffix') ? config('variables.templateSuffix') : 'TemplateSuffix' }}
        </title>

        <meta name="description" content="{{ config('variables.templateDescription') ? config('variables.templateDescription') : '' }}" />

        <meta name="keywords" content="{{ config('variables.templateKeyword') ? config('variables.templateKeyword') : '' }}">

        <!-- laravel CRUD token -->
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <!-- Canonical SEO -->
        <link rel="canonical" href="{{ config('variables.productPage') ? config('variables.productPage') : '' }}">

        <!-- Favicon -->
        <link rel="icon" type="image/x-icon" href="{{ asset('assets/img/favicon/favicon.ico') }}" />

        <!-- Include Styles -->
        <!-- $isFront is used to append the front layout styles only on the front layout otherwise the variable will be blank -->
        @include('layouts/sections/styles' . $isFront)

        <!-- Include Scripts for customizer, helper, analytics, config -->
        <!-- $isFront is used to append the front layout scriptsIncludes only on the front layout otherwise the variable will be blank -->
        @include('layouts/sections/scriptsIncludes' . $isFront)

        <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@200;300;400;500;700;800;900&display=swap" rel="stylesheet">
        
        <style>
            body, * {
                font-family: 'Tajawal', sans-serif !important;
            }
            .template-customizer-open-btn {display: none !important;}

            .app-brand-logo.demo {
                width: 155px;
                height: 53px;
            }
        </style>
    </head>

    <body>
        <!-- Layout Content -->
        @yield('layoutContent')
        <!--/ Layout Content -->

        <!-- Include Scripts -->
        <!-- $isFront is used to append the front layout scripts only on the front layout otherwise the variable will be blank -->
        @include('layouts/sections/scripts' . $isFront)

        @include('sweetalert::alert')

        <!-- Add this to your HTML head section -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    </body>
</html>