@php
    $customizerHidden = 'customizer-hide';
@endphp

@extends('layouts/blankLayout')

@section('title', 'Login Basic - Pages')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/@form-validation/form-validation.scss'])
@endsection

@section('page-style')
    @vite(['resources/assets/vendor/scss/pages/page-auth.scss'])
@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js'])
@endsection

@section('page-script')
    @vite(['resources/assets/js/pages-auth.js'])
@endsection

@section('content')
    <div class="container-xxl">
        <div class="authentication-wrapper authentication-basic container-p-y">
            <div class="authentication-inner py-4">
                <!-- Login -->
                <div class="card">
                    <div class="card-body">
                        <!-- Logo -->
                        <div class="app-brand justify-content-center mb-4 mt-2">
                            <a href="{{ url('/') }}" class="app-brand-link gap-2">
                                <span class="app-brand-logo demo">@include('_partials.macros', ['height' => 20, 'withbg' => 'fill: #fff;'])</span>
                                <span
                                    class="app-brand-text demo text-body fw-bold ms-1">{{ config('variables.templateName') }}</span>
                            </a>
                        </div>
                        <!-- /Logo -->
                        <h4 class="mb-1 pt-2">You're almost done 👌</h4>
                        <p class="mb-4">Start inserting your settings</p>

                        <form id="formAuthentication" class="mb-3" action="{{ route('install.store.default.Settings') }}"
                            method="POST" enctype="multipart/form-data">

                            @csrf

                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <div class="mb-3">
                                <label for="name" class="form-label">Site name</label>

                                <input type="text" class="form-control" id="name" name="site_name"
                                    value="{{ old('site_name') }}" placeholder="Enter site name" autofocus required>

                                @error('name')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="logo" class="form-label">Site Logo</label>

                                <input type="file" name="site_logo" id="logo" class="form-control-file" required>

                                @error('logo')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="favicon" class="form-label">Site Favicon</label>

                                <input type="file" name="site_favicon" id="favicon" class="form-control-file" required>

                                @error('favicon')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="color" class="form-label">Site Color</label>

                                <input type="color" name="primary_color" id="color"
                                    value="{{ old('primary_color', '#000000') }}" class="form-control" required>

                                @error('color')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="theme" class="form-label">Site Theme</label>

                                <select name="site_theme" id="theme" class="form-select" required>
                                    <option value="">-- Select your favorite theme --</option>
                                    <option value="light" {{ old('site_theme') == 'light' ? 'selected' : '' }}>Light
                                    </option>
                                    <option value="dark" {{ old('site_theme') == 'dark' ? 'selected' : '' }}>Dark
                                    </option>
                                </select>

                                @error('theme')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <small class="text-light fw-medium">Allow Users Registration</small>

                                <div class="form-check">
                                    <input name="users_registration" class="form-check-input" type="radio" value="1"
                                        id="users_registration_1"
                                        {{ old('users_registration', '1') == '1' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="users_registration_1">Allow</label>
                                </div>

                                <div class="form-check">
                                    <input name="users_registration" class="form-check-input" type="radio" value="0"
                                        id="users_registration_0" {{ old('users_registration') == '0' ? 'checked' : '' }}>

                                    <label class="form-check-label" for="users_registration_0">Deny</label>
                                </div>

                                @error('users_registration')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <button class="btn btn-primary d-grid w-100" type="submit">Save Settings</button>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- /Register -->
            </div>
        </div>
    </div>
@endsection
