@extends('layouts/layoutMaster')

@section('title', 'Users')

@section('content')
    <h4>All Users</h4>

    <div class="card">
        <h5 class="card-header">Users Table</h5>

        <div class="card-body">
            @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif
            
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Name</th>
                            <th style="width:100px">Status</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Photo</th>
                            <th>Roles</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($users as $user)
                            <tr>
                                <td>
                                    @if($user->isSuperAdmin())
                                    <i class="tf-icons ti ti-crown" id="crown"></i>
                                    @endif
                                    
                                    {{ $user->name }}
                                </td>
                                <td>
                                    <span id="user-{{ $user->id }}">
                                        @if($user->online == 1)
                                            <div class="online-indicator"><span class="blink"></span></div> Online
                                        @else
                                            <div class="offline-indicator"></div> Offline
                                        @endif
                                    </span>
                                </td>
                                <td>{{ $user->email }}</td>
                                <td>{{ $user->phone }}</td>
                                <td>
                                    @if ($user->photo)
                                        <img src="{{ asset('images/' . $user->photo) }}" width="50" alt="User Photo">
                                    @else
                                        N/A
                                    @endif
                                </td>
                                <td>{{ implode(', ', $user->roles->pluck('name')->toArray()) }}</td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>

                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="{{ route('admin.users.edit', $user->id) }}">
                                                <i class="ti ti-pencil me-1"></i>
                                                Edit
                                            </a>

                                            <a class="dropdown-item" href="{{ route('admin.users.show', $user->id) }}">
                                                <i class="ti ti-eye me-1"></i>
                                                Show
                                            </a>

                                            <!-- Check if the user is not Super Admin before showing delete button -->
                                            @if (!$user->hasRole('Super Admin'))
                                                @if($user->active)
                                                    <form method="POST" action="{{ route('admin.users.deactivate', $user) }}">
                                                        @csrf
                                                        @method('PATCH')
                                                        <button type="submit" class="dropdown-item btn btn-danger">
                                                            <i class="ti ti-cog me-1"></i>
                                                            
                                                            Deactivate
                                                        </button>
                                                    </form>
                                                @else
                                                    <form method="POST" action="{{ route('admin.users.activate', $user) }}">
                                                        @csrf

                                                        @method('PATCH')

                                                        <button type="submit" class="dropdown-item btn btn-success">
                                                            <i class="ti ti-cog me-1"></i>
                                                            Activate
                                                        </button>
                                                    </form>
                                                @endif

                                                <form action="{{ route('admin.users.destroy', $user->id) }}" method="POST" class="d-inline" id="deleteForm{{ $user->id }}">
                                                    @csrf

                                                    @method('DELETE')

                                                    <button type="button" class="dropdown-item" onclick="confirmDelete('{{ $user->id }}')">
                                                        <i class="ti ti-trash me-1"></i>
                                                        Delete
                                                    </button>
                                                </form>
                                            @else
                                                <button type="button" class="dropdown-item" disabled><i class="ti ti-trash me-1"></i> Delete Disabled</button>
                                            @endif
                                        </div>
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(authorId) {
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this user',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete this user!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + authorId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                    
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection