@extends('layouts/layoutMaster')

@section('title', 'Settings')

@section('content')
    <h4>Settings</h4>

    <div class="card">
        <h5 class="card-header">Settings</h5>

        <div class="card-body">
            <!-- Display success or error messages -->
            @if (session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            <!-- Wrap all settings in a single form -->
            <form action="{{ route('admin.settings.update') }}" method="post" enctype="multipart/form-data">
                @csrf

                @foreach($settings as $setting)
                    <div class="{{ ($setting->type == 'checkbox' || $setting->type == 'boolean') ? 'form-check mt-3' : 'mb-3' }}">
                        <!-- Format setting name for label -->
                        @php
                        $label = ucwords(str_replace('_', ' ', $setting->key));
                        @endphp

                        @if ($setting->type == 'checkbox' || $setting->type == 'boolean')
                        <label for="{{ $setting->key }}" class="form-check-label">{{ $label }}</label>
                        @else
                        <label for="{{ $setting->key }}" class="form-label">{{ $label }}</label>
                        @endif

                        {{-- Text Type --}}
                        @if ($setting->type == 'text')
                            <input type="text" name="{{ $setting->key }}" id="{{ $setting->key }}" class="form-control" value="{{ $setting->value }}">

                        {{-- Textarea --}}
                        @elseif ($setting->type == 'textarea')
                            <textarea name="{{ $setting->key }}" id="{{ $setting->key }}" class="form-control" rows="4">{{ $setting->value }}</textarea>

                        {{-- File Upload --}}
                        @elseif ($setting->type == 'file')
                            <input type="file" name="{{ $setting->key }}" id="{{ $setting->key }}" class="form-control-file">
                            
                            @if($setting->value !== null)
                                <p>Current File: <a href="{{ asset($setting->value) }}" target="_blank">View</a></p>
                            @endif

                        {{-- Multiple File Uploads --}}
                        @elseif ($setting->type == 'file_multiple')
                            <input type="file" name="{{ $setting->key }}[]" id="{{ $setting->key }}" class="form-control-file" multiple>

                            @if($setting->value !== null)
                                <p>Current Files:
                                    @php $files = json_decode($setting->value, true) @endphp

                                    @foreach($files as $file)
                                        <a href="{{ asset($file) }}" target="_blank">{{ $file }}</a><br>
                                    @endforeach
                                </p>
                            @endif

                        {{-- Color Picker --}}
                        @elseif ($setting->type == 'color')
                            <input type="color" name="{{ $setting->key }}" id="{{ $setting->key }}" class="form-control" value="{{ $setting->value }}">

                        {{-- Date Picker --}}
                        @elseif ($setting->type == 'date')
                            <input type="date" name="{{ $setting->key }}" id="{{ $setting->key }}" class="form-control" value="{{ $setting->value }}">

                        {{-- Checkbox --}}
                        @elseif ($setting->type == 'checkbox' || $setting->type == 'boolean')
                            <input type="checkbox" class="form-check-input" name="{{ $setting->key }}" id="{{ $setting->key }}" value="1" {{ $setting->value ? 'checked' : '' }}>

                        {{-- Radio Buttons --}}
                        @elseif ($setting->type == 'radio')
                            @foreach ($setting->value as $option)
                                <div class="form-check">
                                    <input type="radio" name="{{ $setting->key }}" value="{{ $option }}" id="{{ $setting->key }}_{{ $loop->index }}" class="form-check-input" {{ $setting->value == $option ? 'checked' : '' }}>
                                    <label class="form-check-label" for="{{ $setting->key }}_{{ $loop->index }}">{{ $option }}</label>
                                </div>
                            @endforeach

                        {{-- Dropdown (select) --}}
                        @elseif(is_array($setting->options) || is_object($setting->options))
                                @foreach ($setting->options as $option)
                                    <div class="form-check">
                                        <input type="radio" name="{{ $setting->key }}" value="{{ $option }}" class="form-check-input">
                                        <label class="form-check-label" for="{{ $setting->key }}">{{ $option }}</label>
                                    </div>
                                @endforeach
                            @endif

                        {{-- Multi-select (JSON or array-based) --}}
                        @elseif ($setting->type == 'json')
                            <div id="{{ $setting->key }}-container">
                                @php $values = json_decode($setting->value, true) ?: []; @endphp
                                
                                @foreach ($values as $val)
                                    <input type="text" name="{{ $setting->key }}[]" value="{{ $val }}" class="form-control mb-2">
                                @endforeach
                            </div>

                            <button type="button" class="btn btn-secondary mt-2" onclick="addNewField('{{ $setting->name }}')">Add Field</button>
                        @endif
                        
                        {{-- Description --}}
                        @if ($setting->description)
                            <small class="form-text text-muted">{{ $setting->description }}</small>
                        @endif
                    </div>
                @endforeach
                
                <!-- Single Submit button for all settings -->
                <button type="submit" class="btn btn-primary">Save All Settings</button>
            </form>
        </div>
    </div>

    {{-- JavaScript for adding dynamic input fields --}}
    <script>
        function addNewField(settingName) {
            // Find the container where the new fields should be added
            let container = document.querySelector(`#${settingName}-container`);

            // Create a new input element
            let newInput = document.createElement('input');
            newInput.setAttribute('type', 'text');
            newInput.setAttribute('name', `${settingName}[]`);
            newInput.setAttribute('class', 'form-control mb-2'); // Add classes to style it like others

            // Append the new input to the container
            container.appendChild(newInput);
        }
    </script>
@endsection