@extends('layouts/layoutMaster')

@section('title', 'Create New Setting')

@section('content')
    <h4>Settings</h4>

    <div class="card">
        <h5 class="card-header">Create New Setting</h5>

        <div class="card-body">
            <!-- Display success or error messages -->
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            <form action="{{ route('admin.settings.store') }}" method="POST" enctype="multipart/form-data">
                @csrf

                <div class="form-group mb-3">
                    <label for="name">Setting Name</label>
                    <input type="text" name="name" class="form-control" value="{{ old('name') }}" required>
                    @error('name') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="form-group mb-3">
                    <label for="type">Setting Type</label>
                    <select name="type" class="form-control" required>
                        <option value="text">Text</option>
                        <option value="textarea">Textarea</option>
                        <option value="file">File</option>
                        <option value="boolean">Checkbox</option>
                        <option value="dropdown">Dropdown</option>
                        <option value="radio">Radio Button</option>
                    </select>
                    @error('type') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="form-group mb-3">
                    <label for="group">Setting Group</label>
                    <input type="text" name="group" class="form-control" value="{{ old('group', 'general') }}" required>
                    @error('group') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="form-group mb-3">
                    <label for="value">Setting Value</label>
                    <input type="text" name="value" class="form-control" value="{{ old('value') }}">
                    @error('value') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="form-group mb-3">
                    <label for="description">Description</label>
                    <textarea name="description" class="form-control">{{ old('description') }}</textarea>
                </div>

                <div class="form-group mb-3">
                    <label for="options">Options (for Dropdown/Radio - JSON format)</label>
                    <input type="text" name="options" class="form-control" placeholder='e.g. ["option1", "option2"]'>
                    @error('options') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <button type="submit" class="btn btn-primary">Create Setting</button>
            </form>
        </div>
    </div>
@endsection