@extends('layouts/layoutMaster')

@section('title', 'Edit Permission')

@section('content')
    <form action="{{ route('admin.permissions.update', $permission->id) }}" method="POST">
        @csrf

        @method('PUT')

        <h4>Edit Permission</h4>

        <div class="col-12 col-lg-8">
            <!-- Role Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">Permission Information</h5>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="mb-3">
                        <label class="form-label" for="book-name">Permission Name</label>
                        
                        <input type="text" class="form-control" id="permission-name" placeholder="Permission Name" name="name" aria-label="Permission Name" value="{{ $permission->name }}" required />
                        
                        @error('name')
                            <div style="color: red; font-weight: bold"> {{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-check me-1"></span> Update Role
                </button>
            </div>
        </div>
    </form>
@endsection