@extends('layouts/layoutMaster')

@section('title', 'Create Permission')

@section('content')
    <form action="{{ route('admin.permissions.store') }}" method="POST">
        @csrf 
          
        <h4>Create Permission</h4>

        <div class="col-12 col-lg-8">
            <!-- Role Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">Permission Information</h5>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="mb-3">
                        <label class="form-label" for="role-name">Permission Name</label>

                        <input type="text" class="form-control" id="permission-name" placeholder="Permission Name" name="name" aria-label="permission Name"  value="{{ old('name') }}" required />
                        
                        @error('name')
                            <div style="color: red; font-weight: bold"> {{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-plus me-1"></span>Add New Permission
                </button>
            </div>
        </div>
    </form>
@endsection
