@extends('layouts/layoutMaster')

@section('title', $page->title )

@section('content')
    <div class="col-12 col-lg-12">
        <!-- Role Information -->

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-tile mb-0">{{ $page->title  }}</h5>
            </div>

            <div class="card-body">
                <div class="mb-3">
                    <p class="card-tile mb-0">{{ $page->content }}</p>

                    @if($page->featured_image)
                        <img src="{{ asset('storage/' . $page->featured_image) }}" alt="Featured Image" style="width: 100%; max-width: 600px;">
                    @endif

                    <div>{!! $page->content !!}</div>

                    @if($page->gallery_images)
                        <div class="gallery">
                            @foreach(json_decode($page->gallery_images) as $gallery_image)
                                <img src="{{ asset('storage/' . $gallery_image) }}" alt="Gallery Image" style="width: 100px;">
                            @endforeach
                        </div>
                    @endif

                    @if($page->video)
                        <video width="320" height="240" controls>
                            <source src="{{ asset('storage/' . $page->video) }}" type="video/mp4">
                            Your browser does not support the video tag.
                        </video>
                    @endif

                    <style>
                        .table_component {
                            overflow: auto;
                            width: 100%;
                        }

                        .table_component table {
                            border: 1px solid #dededf;
                            height: 100%;
                            width: 100%;
                            table-layout: fixed;
                            border-collapse: collapse;
                            border-spacing: 1px;
                            text-align: left;
                        }

                        .table_component caption {
                            caption-side: top;
                            text-align: left;
                        }

                        .table_component th {
                            border: 1px solid #dededf;
                            background-color: #eceff1;
                            color: #000000;
                            padding: 5px;
                        }

                        .table_component td {
                            border: 1px solid #dededf;
                            background-color: #ffffff;
                            color: #000000;
                            padding: 5px;
                        }
                    </style>

                    <div class="table_component" role="region" tabindex="0">
                        <table>
                            <tbody>
                                <thead>
                                    <tr>
                                        <td colspan="3"><h3>SEO Fields</h3></td>
                                    </tr>
                                </thead>

                                <tr>
                                    <td><strong>Meta Key</strong></td>

                                    <td>{{ $page->meta_key }}</td>
                                </tr>

                                <tr>
                                    <td><strong>Meta Description</strong></td>

                                    <td>{{ $page->meta_description }}/td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <a href="{{ route('pages.index') }}" class="btn btn-primary">Back to pages</a>
                </div>
            </div>
        </div>
    </div>
@endsection
