@extends('layouts/layoutMaster')

@section('title', 'User Activity Logs')

@section('content')
    <div class="card">
        <h5 class="card-header">User Activity Logs</h5>

        <div class="card-body">
            <div class="table-responsive text-nowrap">
                <!-- Search Form -->
                <form action="{{ route('admin.logs.index') }}" method="GET" class="mb-3">
                    <div class="form-group row">
                        <label for="search" class="col-sm-1 col-form-label">Search:</label>
                        <div class="col-sm-4">
                            <input type="text" name="search" id="search" class="form-control" value="{{ request('search') }}">
                        </div>
                        <div class="col-sm-1">
                            <button type="submit" class="btn btn-primary">Search</button>
                        </div>
                    </div>
                </form>

                <a href="{{ route('admin.logs.export') }}" class="btn btn-success mb-3">Export Logs</a>
                
                <form action="{{ route('admin.logs.clear') }}" method="POST" onsubmit="return confirm('Are you sure you want to clear all logs?')">
                    @csrf
                    <button type="submit" class="btn btn-danger">Empty Logs</button>
                </form>

                @if(session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif

                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>User</th>
                            <th>Action</th>
                            <th>Details</th>
                            <th>IP Address</th>
                            <th>User Agent</th>
                            <th>Date</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach($logs as $log)
                        <tr>
                                <td>{{ $log->user ? $log->user->name : 'Guest' }}</td>
                                <td>{{ $log->action }}</td>
                                <td>{{ $log->details }}</td>
                                <td>{{ $log->ip_address }}</td>
                                <td>{{ $log->user_agent }}</td>
                                <td>{{ $log->created_at->format('Y-m-d H:i:s') }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                {{ $logs->links() }} <!-- Pagination Links -->
            </div>
        </div>
    </div>
@endsection