@extends('layouts/layoutMaster')

@section('title', $labTest->name)

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">{{ $labTest->name }}</h5>
                </div>

                <div class="card-body">
                    <p>{{ $labTest->description }}</p>

                    <div class="mb-3 demo-inline-spacing">
                        <a href="{{ route('admin.lab_tests.edit', $labTest->id) }}" class="btn btn-warning d-inline">Edit</a>

                        <form method="POST" action="{{ route('admin.lab_tests.destroy', $labTest->id) }}" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">Delete</button>
                        </form>

                        <a href="{{ route('admin.lab_tests.index') }}" class="btn btn-primary d-inline">Back to lab tests</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
