@extends('layouts/layoutMaster')

@section('title', 'Lab Tests')

@section('content')
    <h4>Lab Tests</h4>

    <div class="card">
        <h5 class="card-header">Lab Tests</h5>

        <div class="card-body">
            <div class="table-responsive text-nowrap">
                <table class="table table-bordered table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Name</th>
                            <th>Actions</th>
                        </tr>
                    </thead>

                    <tbody>
                            @foreach ($labTests as $labTest)
                            <tr>
                                <td>{{ $labTest->name }}</td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                            data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>
                                    
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="{{ route('admin.lab_tests.edit', $labTest->id) }}">
                                                <i class="ti ti-pencil me-1"></i>
                                                Edit
                                            </a>
                                            
                                            <a class="dropdown-item" href="{{ route('admin.lab_tests.show', $labTest->id) }}">
                                                <i class="ti ti-eye me-1"></i>
                                                Show
                                            </a>

                                            <form action="{{ route('admin.lab_tests.destroy', $labTest->id) }}" method="POST" style="display:inline;" id="deleteForm{{ $labTest->id }}">
                                                @csrf
                                                @method('DELETE')

                                                <button type="submit" class="dropdown-item btn btn-danger" onclick="confirmDelete('{{ $labTest->id }}')">
                                                    <i class="ti ti-trash me-1"></i>
                                                    Delete
                                                </button>
                                            </form>
                                        </div>
                                    </div>

                                    <!-- SweetAlert script -->
                                    <script>
                                        function confirmDelete(labTestId) {
                                            Swal.fire({
                                                title: 'Are you sure?',
                                                text: 'You want to delete this lab test!',
                                                icon: 'warning',
                                                showCancelButton: true,
                                                confirmButtonColor: '#d33',
                                                cancelButtonColor: '#3085d6',
                                                confirmButtonText: 'Yes, delete it!'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    document.getElementById('deleteForm' + schoolId).submit();
                                                }
                                            });
                                        }
                                    </script>
                                    
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection