@extends('layouts/layoutMaster')

@section('title', 'Edit Lab Test')

@section('content')
    <!-- If editing, we use the PUT method, else POST for creating -->
    <form method="POST" action="{{ route('admin.lab_tests.update', $labTest->id) }}">
        @csrf

        @method('PUT')
          
        <h4>Edit Lab Test</h4>

        <div class="col-12 col-lg-8">
            <!-- School  Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">Lab Test Information</h5>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <!-- Name field -->
                    <div class="mb-3">
                        <label for="name">Name:</label>

                        <input type="text" id="name" class="form-control" name="name" value="{{ $labTest->name }}" required>
                    
                        @error('name')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>
                    
                    <!-- Description field -->
                    <div class="mb-3">
                        <label for="description">Description:</label>
                        
                        <textarea id="description" class="form-control" name="description" rows="5" required>{{ $labTest->description }}</textarea>
                    
                        @error('description')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-plus me-1"></span> Update lab test
                </button>
            </div>
        </div>
    </form>
@endsection