@extends('layouts/layoutMaster')

@section('title', 'Send Invitation')

@section('content')
    <form action="{{ route('admin.invitations.store') }}" method="POST">
        @csrf 
          
        <h4>Send Invitation</h4>

        <div class="col-12 col-lg-8">
            <!-- School  Information -->
            <div class="card mb-4">
                <div class="card-body">
                    {{-- Display success or error messages --}}
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="mb-3">
                        <label for="email">Email Address</label>

                        <input type="email" name="email" id="email" class="form-control" required>
                    </div>

                    <div class="form-group mt-3">
                        <label for="name">Name (Optional)</label>
                        <input type="text" name="name" id="name" class="form-control">
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-plus me-1"></span> Send Invitation
                </button>
            </div>
        </div>
    </form>
@endsection
