@extends('layouts/layoutMaster')

@section('title', isset($announcement) ? 'Edit Announcement' : 'Create Announcement')

@section('content')
    <!-- If editing, we use the PUT method, else POST for creating -->
    <form method="POST" action="{{ isset($announcement) ? route('admin.announcements.update', $announcement->id) : route('admin.announcements.store') }}">
        @csrf

        @if(isset($announcement))
            @method('PUT')
        @endif
          
        <h4>{{ isset($announcement) ? 'Edit' : 'Create' }} Announcement</h4>

        <div class="col-12 col-lg-8">
            <!-- School  Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-tile mb-0">Announcement Information</h5>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <!-- Title field -->
                    <div class="mb-3">
                        <label for="title">Title:</label>

                        <input type="text" id="title" class="form-control" name="title" value="{{ old('title', $announcement->title ?? '') }}" required>
                    
                        @error('name')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>
                    
                    <!-- Message field -->
                    <div class="mb-3">
                        <label for="message">Message:</label>
                        
                        <textarea id="message" class="form-control" name="message" required>{{ old('message', $announcement->message ?? '') }}</textarea>
                    
                        @error('message')
                            <div style="color: red;"> {{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Type field -->
                    <div class="mb-3">
                        <label for="type">Type:</label>

                        <select id="type" name="type" class="form-control" required>
                            <option value="normal" {{ old('type', $announcement->type ?? '') == 'normal' ? 'selected' : '' }}>Normal</option>
                            <option value="information" {{ old('type', $announcement->type ?? '') == 'information' ? 'selected' : '' }}>Information</option>
                            <option value="warning" {{ old('type', $announcement->type ?? '') == 'warning' ? 'selected' : '' }}>Warning</option>
                            <option value="success" {{ old('type', $announcement->type ?? '') == 'success' ? 'selected' : '' }}>Success</option>
                        </select>
                    </div>

                    <!-- End date field -->
                    <div class="mb-3">
                        <label for="end_date">End Date (optional):</label>

                        <input type="date" id="end_date" class="form-control" name="end_date" value="{{ old('end_date', $announcement->end_date ?? '') }}">
                    </div>

                    <!-- Permanent field -->
                    <div class="mb-3">
                        <input type="hidden" name="is_permanent" value="0"> <!-- Hidden input for unchecked state -->
                        <label for="permanent">
                            <input type="checkbox" id="permanent" name="is_permanent" value="1" 
                                {{ old('is_permanent', $announcement->is_permanent ?? false) ? 'checked' : '' }}>
                            Permanent
                        </label>
                    </div>

                    <!-- Users selection for assigning announcements -->
                    <div class="mb-3">
                        <label for="users">Assign to Specific Users (optional):</label>

                        <select id="users" name="users[]" class="form-control" multiple>
                            @foreach($users as $user)
                                <option value="{{ $user->id }}" 
                                    {{ isset($announcement) && $announcement->users->contains($user->id) ? 'selected' : '' }}>
                                    {{ $user->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary mb-2">
                    <span class="ti-xs ti ti-plus me-1"></span> {{ isset($announcement) ? 'Update' : 'Create' }} Announcement
                </button>
            </div>
        </div>
    </form>
@endsection