/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import {
    type Localization,
    type ValidateFunctionInterface,
    type ValidateOptions,
    type ValidateResult,
} from '@form-validation/core';

export interface VatOptions extends ValidateOptions {
    // The ISO 3166-1 country code. It can be
    // - A country code
    // - A callback function that returns the country code
    country: string | (() => string);
}
export interface VatLocalization extends Localization {
    vat: {
        countries: {
            [countryCode: string]: string;
        };
        country: string;
        default: string;
    };
}

export function vat(): ValidateFunctionInterface<VatOptions, ValidateResult>;
