/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import {
    type Localization,
    type ValidateFunctionInterface,
    type ValidateOptions,
    type ValidateResult,
} from '@form-validation/core';

export interface PhoneOptions extends ValidateOptions {
    // The ISO 3166-1 country code. It can be
    // - A country code
    // - A callback function that returns the country code
    country: string | (() => string);
}
export interface PhoneLocalization extends Localization {
    phone: {
        countries: {
            [countryCode: string]: string;
        };
        country: string;
        default: string;
    };
}

export function phone(): ValidateFunctionInterface<PhoneOptions, ValidateResult>;
