<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // General settings
        Setting::updateOrCreate(
            ['name' => 'system_name'],
            ['value' => 'ULS', 'type' => 'text', 'group' => 'general']
        );
        
         // Appearance settings
        Setting::updateOrCreate(
            ['name' => 'primary_color'],
            ['value' => '#111', 'type' => 'color', 'group' => 'appearance']
        );

        Setting::updateOrCreate([
            'name' => 'site_theme',
            'value' => 'light',
            'group' => 'appearance',
            'type' => 'select',
            'description' => 'Choose a theme for the site',
            'options' => json_encode(['light', 'dark', 'blue'])
        ]);

        Setting::updateOrCreate([
            'name' => 'site_logo',
            'value' => null,
            'type' => 'file',
            'group' => 'appearance',
        ]);

        // User settings
        Setting::updateOrCreate(
            ['name' => 'users_registration'],
            ['value' => true, 'type' => 'boolean', 'group' => 'user']
        );
    }
}
